//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.plugin.html.guimodel;

import de.ugoe.cs.autoquest.eventcore.guimodel.ICheckBox;

/**
 * <p>
 * a representation for a check box on a web page.
 * </p>
 * 
 * @author Patrick Harms
 */
public class HTMLCheckBox extends HTMLPageElement implements ICheckBox {

    /**
     * <p>
     * default serial version UID
     * </p>
     */
    private static final long serialVersionUID = 1L;

    /**
     * <p>
     * initializes the check box with its specification and its parent
     * </p>
     *
     * @param specification the specification for the represented tag
     * @param parent        the parent of the GUI element
     */
    public HTMLCheckBox(HTMLPageElementSpec specification, HTMLGUIElement parent) {
        super(specification, parent);
    }

    /* (non-Javadoc)
     * @see de.ugoe.cs.autoquest.plugin.html.guimodel.HTMLGUIElement#getElementDescriptor()
     */
    @Override
    protected String getElementDescriptor() {
        return "CheckBox";
    }

}
