//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.eventcore.guimodel;

import java.io.Serializable;

/**
 * <p>
 * Common interface for GUI element specifications.
 * </p>
 * 
 * @version 1.1
 * @author Patrick Harms, Steffen Herbold
 */
public interface IGUIElementSpec extends Serializable {

    /**
     * <p>
     * Returns a string representation of the GUI element type that this specification represents.
     * </p>
     * 
     * @return
     */
    public String getType();
    
    /**
     * <p>
     * Returns a string array with the names of the classes in the hierarchy of the GUI element that
     * this specification represents. The first element is the GUI element's class, the second its
     * parent, the third its grand-parent, etc.
     * </p>
     * <p>
     * In case the class hierarchy is unknown or the GUI elements are not based on
     * object-orientation, this method should <code>return new String[]{getType()};</code>.
     * </p>
     * 
     * @return
     */
    public String[] getTypeHierarchy();

    /**
     * <p>
     * Evaluates if two GUI specifications are similar. Similar means that a heuristic determines
     * that the two GUI specifications describe the same GUI element.
     * </p>
     * 
     * @param other
     *            specification whose similarity to this is evaluated
     * @return true if the specifications are similar; false otherwise
     */
    public boolean getSimilarity(IGUIElementSpec other);

    /**
     * <p>
     * Defines that {@link IGUIElement} implementations have to define equals.
     * </p>
     * 
     * @see Object#equals(Object)
     */
    @Override
    public boolean equals(Object other);

    /**
     * <p>
     * Defines that {@link IGUIElement} implementations have to define hashCode.
     * </p>
     * 
     * @see Object#hashCode()
     */
    @Override
    public int hashCode();
}
