
package de.ugoe.cs.autoquest.usability.rules;

import java.util.List;

import com.google.common.collect.Lists;

import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskModel;
import de.ugoe.cs.autoquest.usability.rules.patterns.LongFormUsageProblem;

/**
 * 
 * <p>
 * A ruleset containing interaction patterns, which might be indicators for potential usability
 * problems.
 * </p>
 * 
 * @author Alexander Deicke
 */
public class PatternRuleset implements UsabilityRuleset {

    /**
     * 
     */
    private final ITaskModel taskModel;

    /**
     * 
     * <p>
     * Constructor. Creates new {@code PatternRuleset} for a given task model.
     * </p>
     * 
     * @param taskModel
     */
    public PatternRuleset(ITaskModel taskModel) {
        this.taskModel = taskModel;
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.autoquest.usability.rules.UsabilityRuleset#evaluationRules()
     */
    @Override
    public List<UsabilityRule> evaluationRules() {
        List<UsabilityRule> rules = Lists.newArrayList();
        rules.add(new LongFormUsageProblem(this.taskModel));
        return rules;
    }

}
