
package de.ugoe.cs.autoquest.plugin.usability2.rules.metrics.visitor;

import java.util.Iterator;

import de.ugoe.cs.autoquest.tasktrees.treeifc.IEventTaskInstance;
import de.ugoe.cs.autoquest.tasktrees.treeifc.IIterationInstance;
import de.ugoe.cs.autoquest.tasktrees.treeifc.IOptionalInstance;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ISelectionInstance;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ISequenceInstance;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskInstance;

public abstract class AbstractVisitor implements IInstanceVisitor {

    @Override
    public void visit(ITaskInstance instance) {
        if (instance instanceof IEventTaskInstance) {
            traverse((IEventTaskInstance) instance);
        }
        else if (instance instanceof IIterationInstance) {
            traverse((IIterationInstance) instance);
        }
        else if (instance instanceof IOptionalInstance) {
            traverse((IOptionalInstance) instance);
        }
        else if (instance instanceof ISelectionInstance) {
            traverse((ISelectionInstance) instance);
        }
        else if (instance instanceof ISequenceInstance) {
            traverse((ISequenceInstance) instance);
        }

    }

    private void iterate(Iterator<ITaskInstance> iterator) {
        while (iterator.hasNext()) {
            visit(iterator.next());
        }
    }

    private void traverse(ISequenceInstance instance) {
        visit(instance);
        iterate(instance.iterator());
    }

    private void traverse(ISelectionInstance instance) {
        visit(instance);
    }

    private void traverse(IOptionalInstance instance) {
        visit(instance);

    }

    private void traverse(IIterationInstance instance) {
        visit(instance);
        iterate(instance.iterator());
    }

    private void traverse(IEventTaskInstance instance) {
        visit(instance);
    }

    @Override
    public void visit(IEventTaskInstance instance) {}

    @Override
    public void visit(IIterationInstance instance) {}

    @Override
    public void visit(IOptionalInstance instance) {}

    @Override
    public void visit(ISelectionInstance instance) {}

    @Override
    public void visit(ISequenceInstance instance) {}
}
