package de.ugoe.cs.autoquest.androidmonitor;

import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.StringWriter;

import org.xmlpull.v1.XmlSerializer;

import android.app.Activity;
import android.content.Context;
import android.util.Log;
import android.util.Xml;

public class AndroidmonitorLogFile extends Activity {
	// extends activity to use the file handling methods of an activity
	private String name;


	public AndroidmonitorLogFile(String appName, File dir) {		
		this.name = appName + "LogFile.xml";
		
		try {
			File file = new File(dir, this.name);
			if (!file.exists()) {
				Log.d("file", this.name + " - is not available");
				
				//create file
				try {
					OutputStreamWriter outputStreamWriter = new OutputStreamWriter(
							openFileOutput(this.name, Context.MODE_PRIVATE));
					outputStreamWriter.write(getDeviceInformation() + getAppInformation());
					outputStreamWriter.close();
				} catch (IOException e) {
					e.printStackTrace();
					Log.e("outputStreamWriter", e.getMessage());
				}
				

			}
		} catch (Exception e) {
			e.printStackTrace();
			Log.e("file", e.getMessage());
		}

	}

	/**
	 * get file name
	 * 
	 * @return
	 */
	public String getName() {
		return this.name;
	}

	private String getAppInformation() {
		// app Name ...
		return "";
	}
	
	private String getDeviceInformation(){
		String deviceInformation = null;
		try {
			XmlSerializer xmlSerializer = Xml.newSerializer();
			StringWriter stringWriter = new StringWriter(); 
			
			xmlSerializer.setOutput(stringWriter);
			xmlSerializer.startDocument("UTF-8", true);
			xmlSerializer.startTag("", "device");
			xmlSerializer.startTag("", "param");
			xmlSerializer.attribute("", "value", "" + android.os.Build.VERSION.SDK_INT);
			xmlSerializer.attribute("", "name", "sdk_version");
			xmlSerializer.endTag("", "param");
			
			xmlSerializer.startTag("", "param");
			xmlSerializer.attribute("", "value", android.os.Build.DEVICE);
			xmlSerializer.attribute("", "name", "device");
			xmlSerializer.endTag("", "param");
			
			xmlSerializer.startTag("", "param");
			xmlSerializer.attribute("", "value", android.os.Build.MANUFACTURER);
			xmlSerializer.attribute("", "name", "manufacturer");
			xmlSerializer.endTag("", "param");
			
			xmlSerializer.startTag("", "param");
			xmlSerializer.attribute("", "value", android.os.Build.MODEL);
			xmlSerializer.attribute("", "name", "model");
			xmlSerializer.endTag("", "param");
			
			//tbd get resolution ...
			
			
			xmlSerializer.endTag("", "device");
			deviceInformation = stringWriter.toString();
			
		} catch (Exception e) {
			e.printStackTrace();
			Log.e("xmlSerializer", e.getMessage());
		}
		
		return deviceInformation;
	}

	public void addComponent(){
		//add component to file
	}
	
	public void addEvent(){
		//add event to file
	}
	
}
