package de.ugoe.cs.autoquest.androidmonitor;

import java.io.File;
import java.io.FileOutputStream;
import java.io.StringWriter;

import org.xmlpull.v1.XmlSerializer;

import android.util.Log;
import android.util.Xml;

public class AndroidmonitorLogFile {

	private String name;

	public AndroidmonitorLogFile(String appName, File dir) {
		this.name = "android_" + appName + "_LogFile.xml";

		try {
			// prove if file exists
			File file = new File(dir, this.name);
			/*
			 * if file does not exists write device and app information to a new
			 * file. Otherwise use existing file and add activity information to
			 * file.
			 */
			if (true) { //!file.exists() 
				/*
				 * create log file. Using method openFileOutput() does not work
				 * for this project due to the reason that this method would try
				 * to create the file in the directory of the non-existing
				 * directory de.ugoe.cs.androidmonitor. This directory does not
				 * exist due to the reason that this project is a library and
				 * the file has to be stored in the directory of the running
				 * application. Furthermore it would not be possible to write in
				 * another app directory as the own one.
				 */
				String string = getDeviceInformation() + getAppInformation();
				try {
					FileOutputStream outputStream = new FileOutputStream(file);
					outputStream.write(string.getBytes());
					outputStream.close();
				} catch (Exception e) {
					Log.e("file", "outputstream: " + e.getMessage());
				}

			}
		} catch (Exception e) {
			e.printStackTrace();
			Log.e("file", "file: " + e.getMessage());
		}

	}

	/**
	 * get file name
	 * 
	 * @return
	 */
	public String getName() {
		return this.name;
	}

	private String getAppInformation() {
		// app Name ...
		return "";
	}

	private String getDeviceInformation() {
		String deviceInformation = "";
		XmlSerializer serializer = Xml.newSerializer(); 
		StringWriter writer = new StringWriter();
		try {
			serializer.setOutput(writer);
			serializer.startDocument("UTF-8", true);
			serializer.startTag("", "device");
			serializer.startTag("", "param");
			serializer.attribute("", "value", ""
					+ android.os.Build.VERSION.SDK_INT);
			serializer.attribute("", "name", "sdk_version");
			serializer.endTag("", "param");

			serializer.startTag("", "param");
			serializer.attribute("", "value", android.os.Build.DEVICE);
			serializer.attribute("", "name", "device");
			serializer.endTag("", "param");

			serializer.startTag("", "param");
			serializer.attribute("", "value", android.os.Build.MANUFACTURER);
			serializer.attribute("", "name", "manufacturer");
			serializer.endTag("", "param");

			serializer.startTag("", "param");
			serializer.attribute("", "value", android.os.Build.MODEL);
			serializer.attribute("", "name", "model");
			serializer.endTag("", "param");

			// tbd get resolution ...

			serializer.endTag("", "device");
			serializer.endDocument();
			
			deviceInformation = writer.toString();

		} catch (Exception e) {
			Log.e("xml", e.getMessage()); 
		}

		return deviceInformation;
	}

	public void addComponent() {
		// add component to file
	}

	public void addEvent() {
		// add event to file
	}

}
