//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.commands.usage;

import java.util.Collection;
import java.util.List;

import de.ugoe.cs.autoquest.CommandHelpers;
import de.ugoe.cs.autoquest.SequenceInstanceOf;
import de.ugoe.cs.autoquest.eventcore.Event;
import de.ugoe.cs.autoquest.usageprofiles.TrieBasedModel;
import de.ugoe.cs.util.console.Command;
import de.ugoe.cs.util.console.GlobalDataContainer;

/**
 * <p>
 * Command to update a {@link TrieBasedModel}.
 * </p>
 * 
 * @author Steffen Herbold
 * @version 1.0
 */
public class CMDupdateModel implements Command {

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.util.console.Command#run(java.util.List)
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void run(List<Object> parameters) {
		String modelname;
		String sequencesName;

		try {
			modelname = (String) parameters.get(0);
			sequencesName = (String) parameters.get(1);
		} catch (Exception e) {
			throw new IllegalArgumentException();
		}

		Object dataObject = GlobalDataContainer.getInstance().getData(
				sequencesName);
		if (dataObject == null) {
			CommandHelpers.objectNotFoundMessage(sequencesName);
			return;
		}
		if (!SequenceInstanceOf.isCollectionOfSequences(dataObject)) {
			CommandHelpers.objectNotType(sequencesName,
					"Collection<List<Event<?>>>");
			return;
		}
		Collection<List<Event>> sequences = (Collection<List<Event>>) dataObject;

		dataObject = GlobalDataContainer.getInstance().getData(modelname);
		if (dataObject == null) {
			CommandHelpers.objectNotFoundMessage(modelname);
			return;
		}
		if (!(dataObject instanceof TrieBasedModel)) {
			CommandHelpers.objectNotType(modelname, "TrieBasedModel");
			return;
		}

		TrieBasedModel model = (TrieBasedModel) dataObject;
		model.update(sequences);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.util.console.Command#help()
	 */
	@Override
	public String help() {
		return "updateModel <modelname> <sequencesName>";
	}

}
