/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.samples;

import edu.uci.ics.jung.algorithms.generators.random.EppsteinPowerLawGenerator;
import edu.uci.ics.jung.algorithms.layout.FRLayout;
import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.algorithms.shortestpath.BFSDistanceLabeler;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.SparseMultigraph;
import edu.uci.ics.jung.graph.util.Pair;
import edu.uci.ics.jung.visualization.Layer;
import edu.uci.ics.jung.visualization.VisualizationServer;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.DefaultModalGraphMouse;
import edu.uci.ics.jung.visualization.decorators.ToStringLabeller;
import edu.uci.ics.jung.visualization.renderers.Renderer;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.commons.collections15.Factory;
import org.apache.commons.collections15.Transformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShortestPathDemo
extends JPanel {
    private static final long serialVersionUID = 7526217664458188502L;
    private String mFrom;
    private String mTo;
    private Graph<String, Number> mGraph = this.getGraph();
    private Set<String> mPred;

    public ShortestPathDemo() {
        this.setBackground(Color.WHITE);
        FRLayout layout = new FRLayout(this.mGraph);
        VisualizationViewer vv = new VisualizationViewer((Layout)layout);
        vv.setBackground(Color.WHITE);
        vv.getRenderContext().setVertexDrawPaintTransformer(new MyVertexDrawPaintFunction());
        vv.getRenderContext().setVertexFillPaintTransformer(new MyVertexFillPaintFunction());
        vv.getRenderContext().setEdgeDrawPaintTransformer((Transformer)new MyEdgePaintFunction());
        vv.getRenderContext().setEdgeStrokeTransformer((Transformer)new MyEdgeStrokeFunction());
        vv.getRenderContext().setVertexLabelTransformer((Transformer)new ToStringLabeller());
        vv.setGraphMouse((VisualizationViewer.GraphMouse)new DefaultModalGraphMouse());
        vv.addPostRenderPaintable(new VisualizationServer.Paintable((Layout)layout, vv){
            final /* synthetic */ Layout val$layout;
            final /* synthetic */ VisualizationViewer val$vv;
            {
                this.val$layout = layout;
                this.val$vv = visualizationViewer;
            }

            public boolean useTransform() {
                return true;
            }

            public void paint(Graphics g) {
                if (ShortestPathDemo.this.mPred == null) {
                    return;
                }
                for (Number e : this.val$layout.getGraph().getEdges()) {
                    if (!ShortestPathDemo.this.isBlessed(e)) continue;
                    String v1 = (String)ShortestPathDemo.this.mGraph.getEndpoints(e).getFirst();
                    String v2 = (String)ShortestPathDemo.this.mGraph.getEndpoints(e).getSecond();
                    Point2D p1 = (Point2D)this.val$layout.transform((Object)v1);
                    Point2D p2 = (Point2D)this.val$layout.transform((Object)v2);
                    p1 = this.val$vv.getRenderContext().getMultiLayerTransformer().transform(Layer.LAYOUT, p1);
                    p2 = this.val$vv.getRenderContext().getMultiLayerTransformer().transform(Layer.LAYOUT, p2);
                    Renderer renderer = this.val$vv.getRenderer();
                    renderer.renderEdge(this.val$vv.getRenderContext(), this.val$layout, (Object)e);
                }
            }
        });
        this.setLayout(new BorderLayout());
        this.add((Component)vv, "Center");
        this.add((Component)this.setUpControls(), "South");
    }

    boolean isBlessed(Number e) {
        String v2;
        Pair<String> endpoints = this.mGraph.getEndpoints(e);
        String v1 = endpoints.getFirst();
        return !v1.equals(v2 = endpoints.getSecond()) && this.mPred.contains(v1) && this.mPred.contains(v2);
    }

    private JPanel setUpControls() {
        JPanel jp = new JPanel();
        jp.setBackground(Color.WHITE);
        jp.setLayout(new BoxLayout(jp, 3));
        jp.setBorder(BorderFactory.createLineBorder(Color.black, 3));
        jp.add(new JLabel("Select a pair of vertices for which a shortest path will be displayed"));
        JPanel jp2 = new JPanel();
        jp2.add(new JLabel("vertex from", 2));
        jp2.add(this.getSelectionBox(true));
        jp2.setBackground(Color.white);
        JPanel jp3 = new JPanel();
        jp3.add(new JLabel("vertex to", 2));
        jp3.add(this.getSelectionBox(false));
        jp3.setBackground(Color.white);
        jp.add(jp2);
        jp.add(jp3);
        return jp;
    }

    private Component getSelectionBox(final boolean from) {
        TreeSet<String> s = new TreeSet<String>();
        for (String v : this.mGraph.getVertices()) {
            s.add(v);
        }
        final JComboBox<Object> choices = new JComboBox<Object>(s.toArray());
        choices.setSelectedIndex(-1);
        choices.setBackground(Color.WHITE);
        choices.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String v = (String)choices.getSelectedItem();
                if (from) {
                    ShortestPathDemo.this.mFrom = v;
                } else {
                    ShortestPathDemo.this.mTo = v;
                }
                ShortestPathDemo.this.drawShortest();
                ShortestPathDemo.this.repaint();
            }
        });
        return choices;
    }

    protected void drawShortest() {
        if (this.mFrom == null || this.mTo == null) {
            return;
        }
        BFSDistanceLabeler bdl = new BFSDistanceLabeler();
        bdl.labelDistances(this.mGraph, (Object)this.mFrom);
        this.mPred = new HashSet<String>();
        String v = this.mTo;
        Set prd = bdl.getPredecessors((Object)v);
        this.mPred.add(this.mTo);
        while (prd != null && prd.size() > 0) {
            v = (String)prd.iterator().next();
            this.mPred.add(v);
            if (v == this.mFrom) {
                return;
            }
            prd = bdl.getPredecessors((Object)v);
        }
    }

    public static void main(String[] s) {
        JFrame jf = new JFrame();
        jf.setDefaultCloseOperation(3);
        jf.getContentPane().add(new ShortestPathDemo());
        jf.pack();
        jf.setVisible(true);
    }

    Graph<String, Number> getGraph() {
        Graph g = new EppsteinPowerLawGenerator((Factory)new GraphFactory(), (Factory)new VertexFactory(), (Factory)new EdgeFactory(), 26, 50, 50).create();
        HashSet<String> removeMe = new HashSet<String>();
        for (String v : g.getVertices()) {
            if (g.degree(v) != 0) continue;
            removeMe.add(v);
        }
        for (String v : removeMe) {
            g.removeVertex(v);
        }
        return g;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class EdgeFactory
    implements Factory<Number> {
        int count;

        EdgeFactory() {
        }

        @Override
        public Number create() {
            return this.count++;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class VertexFactory
    implements Factory<String> {
        char a = (char)97;

        VertexFactory() {
        }

        @Override
        public String create() {
            char c = this.a;
            this.a = (char)(c + '\u0001');
            return Character.toString(c);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class GraphFactory
    implements Factory<Graph<String, Number>> {
        GraphFactory() {
        }

        @Override
        public Graph<String, Number> create() {
            return new SparseMultigraph();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class MyVertexFillPaintFunction<V>
    implements Transformer<V, Paint> {
        @Override
        public Paint transform(V v) {
            if (v == ShortestPathDemo.this.mFrom) {
                return Color.BLUE;
            }
            if (v == ShortestPathDemo.this.mTo) {
                return Color.BLUE;
            }
            if (ShortestPathDemo.this.mPred == null) {
                return Color.LIGHT_GRAY;
            }
            if (ShortestPathDemo.this.mPred.contains(v)) {
                return Color.RED;
            }
            return Color.LIGHT_GRAY;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class MyVertexDrawPaintFunction<V>
    implements Transformer<V, Paint> {
        @Override
        public Paint transform(V v) {
            return Color.black;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class MyEdgeStrokeFunction
    implements Transformer<Number, Stroke> {
        protected final Stroke THIN = new BasicStroke(1.0f);
        protected final Stroke THICK = new BasicStroke(1.0f);

        @Override
        public Stroke transform(Number e) {
            if (ShortestPathDemo.this.mPred == null || ShortestPathDemo.this.mPred.size() == 0) {
                return this.THIN;
            }
            if (ShortestPathDemo.this.isBlessed(e)) {
                return this.THICK;
            }
            return this.THIN;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class MyEdgePaintFunction
    implements Transformer<Number, Paint> {
        @Override
        public Paint transform(Number e) {
            if (ShortestPathDemo.this.mPred == null || ShortestPathDemo.this.mPred.size() == 0) {
                return Color.BLACK;
            }
            if (ShortestPathDemo.this.isBlessed(e)) {
                return new Color(0.0f, 0.0f, 1.0f, 0.5f);
            }
            return Color.LIGHT_GRAY;
        }
    }
}

