package de.ugoe.cs.eventbench.swing;

import java.awt.EventQueue;
import java.awt.Rectangle;

import javax.swing.DefaultListModel;
import javax.swing.JFrame;
import javax.swing.JButton;
import javax.swing.JScrollBar;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JList;
import java.util.List;
import javax.swing.ListSelectionModel;
import javax.swing.border.SoftBevelBorder;
import javax.swing.border.BevelBorder;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.ListSelectionEvent;

import de.ugoe.cs.eventbench.data.Event;

import javax.swing.JLabel;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JScrollPane;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;

public class DlgSequenceDetails {

	private JFrame frmEvents;
	private JFrame frmParent;

	/**
	 * Launch the application, the index of the sequence to work on is stored in
	 * sequenceIndex
	 */
	public void showDialog(JFrame parent, final List<Event<?>> events) {
		frmParent = parent;

		EventQueue.invokeLater(new Runnable() {
			public void run() {
				try {
					DlgSequenceDetails window = new DlgSequenceDetails(
							frmParent, events);
					window.frmEvents.setVisible(true);
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		});
	}

	/**
	 * Create the application.
	 */
	public DlgSequenceDetails(JFrame parent, final List<Event<?>> events) {
		frmParent = parent;
		initialize(events);
	}

	/**
	 * Initialize the contents of the frame.
	 */
	private void initialize(final List<Event<?>> events) {

		final DefaultListModel modelListEvents = new DefaultListModel();
		final DefaultListModel modelListTargets = new DefaultListModel();
		final JList listEvents = new JList(modelListEvents);
		final JList listTargets = new JList(modelListTargets);
		// ***

		// JFrame: frmEvents
		frmEvents = new JFrame();
		frmEvents.setResizable(false);
		frmEvents.setTitle("Sequence details");
		frmEvents.setBounds(100, 100, 731, 589);
		frmEvents.setDefaultCloseOperation(JFrame.DO_NOTHING_ON_CLOSE);
		frmEvents.getContentPane().setLayout(null);

		frmEvents.addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent arg0) {
				frmParent.setVisible(true);
				frmEvents.dispose();
			}
		});

		updateLists(events, modelListEvents, modelListTargets);

		JPanel panel = new JPanel();
		panel.setBorder(new EtchedBorder(EtchedBorder.LOWERED, null, null));
		panel.setBounds(10, 498, 705, 52);
		frmEvents.getContentPane().add(panel);
		panel.setLayout(null);
		final JButton btnInsertBefore = new JButton("Insert before");
		btnInsertBefore.setBounds(10, 11, 135, 31);
		panel.add(btnInsertBefore);
		// ***

		// JButton: btnInsertBefore ***
		btnInsertBefore.addMouseListener(new MouseAdapter() {
			public void mouseClicked(MouseEvent arg0) {
				if (!btnInsertBefore.isEnabled())
					return;

				int selectedIndex = listEvents.getSelectedIndex();
				DlgInsert.showDialog(events, selectedIndex, true);

				updateLists(events, modelListEvents, modelListTargets);
				listEvents.setSelectedIndex(selectedIndex);
			}
		});

		btnInsertBefore.setEnabled(false);
		final JButton btnInsertAfter = new JButton("Insert after");
		btnInsertAfter.setBounds(155, 11, 135, 31);
		panel.add(btnInsertAfter);
		// ***

		// JButton: btnInsertAfter
		btnInsertAfter.addMouseListener(new MouseAdapter() {
			public void mouseClicked(MouseEvent arg0) {
				if (!btnInsertAfter.isEnabled())
					return;

				int selectedIndex = listEvents.getSelectedIndex();
				DlgInsert.showDialog(events, selectedIndex, false);

				updateLists(events, modelListEvents, modelListTargets);
				listEvents.setSelectedIndex(selectedIndex + 1);
			}
		});

		btnInsertAfter.setEnabled(false);

		final JButton btnClose = new JButton("Back to sequences");
		btnClose.setBounds(544, 11, 150, 31);
		panel.add(btnClose);

		JPanel panel_1 = new JPanel();
		panel_1.setBorder(new EtchedBorder(EtchedBorder.LOWERED, null, null));
		panel_1.setBounds(10, 11, 705, 476);
		frmEvents.getContentPane().add(panel_1);
		panel_1.setLayout(null);

		final JScrollPane scrollPaneEvents = new JScrollPane();
		scrollPaneEvents.setBounds(10, 29, 209, 436);
		panel_1.add(scrollPaneEvents);
		scrollPaneEvents.setViewportView(listEvents);
		// ***

		// JList: listEvents ***
		listEvents.setBorder(new SoftBevelBorder(BevelBorder.LOWERED, null,
				null, null, null));
		listEvents.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);

		// JScrollPane: scrollPane
		final JScrollPane scrollPaneTargets = new JScrollPane();
		scrollPaneTargets.setBounds(229, 29, 466, 436);
		panel_1.add(scrollPaneTargets);
		
		Rectangle r = scrollPaneEvents.getBounds();
		r.height -= 18;
		if(scrollPaneEvents.getVerticalScrollBar().isVisible()) scrollPaneEvents.setBounds(r);

		listTargets.addListSelectionListener(new ListSelectionListener() {
			public void valueChanged(ListSelectionEvent arg0) {
				if (listTargets.getSelectedIndex() > -1) {
					
					JScrollBar bar1 = scrollPaneEvents.getVerticalScrollBar();
					JScrollBar bar2 = scrollPaneTargets.getVerticalScrollBar();
					bar1.setValue(bar2.getValue());

					listEvents.setSelectedIndex(listTargets
							.getSelectedIndex());
					btnInsertAfter.setEnabled(true);

					if (listTargets.getSelectedIndex() == 0) {
						btnInsertBefore.setEnabled(false);
					} else {
						btnInsertBefore.setEnabled(true);
					}
				}
			}
		});
		scrollPaneTargets.setViewportView(listTargets);
		// ***

		// JList for targets ***
		listTargets.setBorder(new SoftBevelBorder(BevelBorder.LOWERED, null,
				null, null, null));
		listTargets.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);

		JLabel lblEvents = new JLabel("Events:");
		lblEvents.setBounds(10, 11, 46, 14);
		panel_1.add(lblEvents);

		JLabel lblTargets = new JLabel("Targets:");
		lblTargets.setBounds(229, 11, 58, 14);
		panel_1.add(lblTargets);

		listEvents.addListSelectionListener(new ListSelectionListener() {
			public void valueChanged(ListSelectionEvent arg0) {
				if (listEvents.getSelectedIndex() > -1) {
					
					JScrollBar bar1 = scrollPaneEvents.getVerticalScrollBar();
					JScrollBar bar2 = scrollPaneTargets.getVerticalScrollBar();
					bar2.setValue(bar1.getValue());
					
					listTargets.setSelectedIndex(listEvents
							.getSelectedIndex());				

					if (listEvents.getSelectedIndex() == 0) {
						btnInsertBefore.setEnabled(false);
						btnInsertAfter.setEnabled(true);
					} else {
						btnInsertBefore.setEnabled(true);
						btnInsertAfter.setEnabled(true);
					}
				}
			}
		});
		// ***

		// JButton: btnClose ***
		btnClose.addMouseListener(new MouseAdapter() {
			public void mouseClicked(MouseEvent arg0) {
				frmParent.setVisible(true);
				frmEvents.dispose();
			}
		});
		// ***
	}

	private void updateLists(final List<Event<?>> events,
			final javax.swing.DefaultListModel modelListEvents,
			final javax.swing.DefaultListModel modelListTargets) {

		modelListEvents.clear();
		modelListTargets.clear();
		for (int i = 0; i < events.size(); i++) {
			modelListEvents.addElement(events.get(i).getType());
			modelListTargets.addElement(events.get(i).getTarget());
		}
	}
}
