package de.ugoe.cs.eventbench.commands;

import java.security.InvalidParameterException;
import java.util.List;

import de.ugoe.cs.eventbench.data.GlobalDataContainer;
import de.ugoe.cs.eventbench.models.IStochasticProcess;
import de.ugoe.cs.util.console.Command;
import de.ugoe.cs.util.console.Console;

/**
 * <p>
 * Command that prints the size of a stochastic process to the console.
 * </p>
 * 
 * @author Steffen Herbold
 * @version 1.0
 */
public class CMDmodelSize implements Command {

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.util.console.Command#run(java.util.List)
	 */
	@Override
	public void run(List<Object> parameters) {
		String modelname;
		try {
			modelname = (String) parameters.get(0);
		} catch (Exception e) {
			throw new InvalidParameterException();
		}

		Object dataObject = GlobalDataContainer.getInstance()
				.getData(modelname);
		if (dataObject == null) {
			Console.printerrln("No model with name " + modelname + "found");
			return;
		}
		if (!(dataObject instanceof IStochasticProcess)) {
			Console.printerrln("Object " + modelname
					+ " not of type IStochasticProcess!");
			return;
		}

		IStochasticProcess process = (IStochasticProcess) dataObject;
		Console.println("#symbols: " + process.getNumSymbols()
				+ " ; #FOMstates " + process.getNumFOMStates());
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.util.console.Command#help()
	 */
	@Override
	public void help() {
		Console.println("Usage: modelSize <modelName>");
	}

}
