package de.ugoe.cs.autoquest.tasktrees.alignment.algorithms;

public class AlignmentAlgorithmFactory {

	public static AlignmentAlgorithm create() {
		Class<?> newclass;
		Object object = null;
		try {
			newclass = Class.forName(algorithmclass);
			object = newclass.newInstance();

		} catch (ClassNotFoundException | SecurityException
				| InstantiationException | IllegalAccessException
				| IllegalArgumentException e) {
			e.printStackTrace();
		}
		return (AlignmentAlgorithm) object;
	}

	public static void setDefaultAlgorithm(String algorithmname) {
		// TODO: check for valid algorihm class names here
		algorithmclass = algorithmname;
	}

	private static String algorithmclass = "de.ugoe.cs.autoquest.tasktrees.alignment.algorithms.SmithWatermanRepeated";
}
