package de.ugoe.cs.autoquest.tasktrees.alignment.matrix;

import java.util.ArrayList;

//Must be initialized!
public class DynamicTriangleMatrix implements ITriangleMatrix {

	private final ArrayList<Float> matrix;
	protected int size;
	private float initalizationValue;

	public DynamicTriangleMatrix(int size) {
		this.size = size;
		matrix = new ArrayList<Float>();
		matrix.ensureCapacity(size * (size + (1 / 2)));
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * de.ugoe.cs.autoquest.tasktrees.alignment.matrix.ITriangleMatrix#get(int,
	 * int)
	 */
	@Override
	public float get(int first, int second) {
		final int row = Math.min(first, second);
		final int col = Math.max(first, second);
		return matrix.get((row * size)
				- (((row * (row + 1)) / 2) - (size - col)));

	}

	// Increases the size
	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * de.ugoe.cs.autoquest.tasktrees.alignment.matrix.ITriangleMatrix#increaseSize
	 * (int)
	 */
	@Override
	public void increaseSize(int count) {
		final int oldsize = size;
		this.size += count;
		matrix.ensureCapacity(size * (size + (1 / 2)));
		for (int i = 0; i < ((oldsize * count) + ((count * (count + 1)) / 2)); i++) {
			matrix.add(this.initalizationValue);
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * de.ugoe.cs.autoquest.tasktrees.alignment.matrix.ITriangleMatrix#initialize
	 * (float)
	 */
	@Override
	public void initialize(float value) {
		this.initalizationValue = value;
		matrix.clear();
		for (int i = 0; i < ((this.size * (this.size + 1)) / 2); i++) {
			matrix.add(value);
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * de.ugoe.cs.autoquest.tasktrees.alignment.matrix.ITriangleMatrix#set(int,
	 * int, float)
	 */
	@Override
	public void set(int first, int second, float value) {
		final int row = Math.min(first, second);
		final int col = Math.max(first, second);
		matrix.set((row * size) - (((row * (row + 1)) / 2) - (size - col)),
				value);
	}

	@Override
	public int size() {
		return size;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * de.ugoe.cs.autoquest.tasktrees.alignment.matrix.ITriangleMatrix#toString
	 * ()
	 */
	@Override
	public String toString() {
		String result = "";
		for (int i = 0; i < size; i++) {
			for (int j = 0; j < size; j++) {
				if (i < j) {
					if (Float.isInfinite(this.get(i, j))) {
						result = result + " -------";
					} else {
						result = result
								+ String.format("%+8.2f", this.get(i, j));
					}
				} else {
					result = result + ("        ");
				}
			}
			result = result + "\n";
		}
		return result;
	}
}
