//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.tasktrees.treeifc;

/**
 * <p>
 * Event tasks represent single events. They have no children and are therefore
 * the leaf nodes of a task model. They provide information about the event they
 * represent as a String description. They do not refer to events, as they may
 * represented several semantically equal but lexically different events. Their
 * description carries as much information as required to show the level of
 * distinction.
 * </p>
 * 
 * @author Patrick Harms
 */
public interface IEventTask extends ITask {

	/**
	 * <p>
	 * returns a clone of this task, i.e. another event task being identical to
	 * this. The event type and target are not cloned but reused.
	 * </p>
	 * 
	 * @return as described
	 */
	@Override
	public IEventTask clone();

}
