//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.tasktrees.treeifc;

import java.util.List;

/**
 * <p>
 * A user session represents task executions, i.e. a task instances of a
 * specific user that were executed in a coherent manner. Therefore, they are an
 * ordered list of task instances where the order denotes the order of the task
 * executions.
 * </p>
 * 
 * @author Patrick Harms
 */
public interface IUserSession extends ITaskInstanceList {

	/**
	 * <p>
	 * clones a user session by creating exact clones of each contained instance
	 * in their order
	 * </p>
	 * 
	 * @return a clone of the session
	 */
	public IUserSession clone();

	/**
	 * <p>
	 * compares the user session with another one. Two user sessions are only
	 * equal, if they contain the same number of task instances and if each task
	 * instance at each position is equal to the respective other session.
	 * </p>
	 * 
	 * @param userSession
	 *            the session to compare the session to
	 * 
	 * @return true if both sessions are equal, false else
	 */
	public boolean equals(IUserSession userSession);

	/**
	 * <p>
	 * returns the list of task instances executed in the represented session.
	 * </p>
	 * 
	 * @return as described
	 */
	public List<ITaskInstance> getExecutedTasks();

	/**
	 * <p>
	 * returns a hash code for the session to be able to store the session in a
	 * hash map.
	 * </p>
	 * 
	 * @return as described
	 */
	@Override
	public int hashCode();

}
