package de.ugoe.cs.autoquest.tasktrees.alignment.algorithms;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;

public class Match implements Serializable {
	/**
	 * 
	 */
	private static final long serialVersionUID = -3206992723755714741L;

	private final ArrayList<NumberSequence> matchseqs;

	private LinkedList<MatchOccurence> occurences;

	public Match() {
		matchseqs = new ArrayList<NumberSequence>(2);
		occurences = new LinkedList<MatchOccurence>();
		matchseqs.add(null);
		matchseqs.add(null);
	}

	public void addOccurence(MatchOccurence occurence) {
		occurences.add(occurence);
	}

	public void addOccurencesOf(Match m) {
		occurences.addAll(m.getOccurences());
	}

	public boolean equals(Match m) {
		if ((m.getFirstSequence().equals(this.getFirstSequence()) || m
				.getFirstSequence().equals(this.getSecondSequence()))
				&& (m.getSecondSequence().equals(this.getFirstSequence()) || m
						.getSecondSequence().equals(this.getSecondSequence()))) {
			return true;
		}
		return false;
	}

	public NumberSequence getFirstSequence() {
		return matchseqs.get(0);
	}

	public LinkedList<MatchOccurence> getOccurences() {
		return occurences;
	}

	public NumberSequence getSecondSequence() {
		return matchseqs.get(1);
	}

	public int occurenceCount() {
		return occurences.size();
	}

	public void setFirstSequence(NumberSequence seq) {
		matchseqs.set(0, seq);
	}

	public void setOccurences(LinkedList<MatchOccurence> occurences) {
		this.occurences = occurences;
	}

	public void setSecondSequence(NumberSequence seq) {
		matchseqs.set(1, seq);
	}

	public int size() {
		// Both sequences should be equally long
		return matchseqs.get(0).size();
	}

}
