package de.ugoe.cs.autoquest.tasktrees.alignment.matrix;

import java.io.Serializable;

public class StaticTriangleMatrix implements ITriangleMatrix, Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 7599542322424894866L;
	private final float[] matrix;
	protected int size;

	public StaticTriangleMatrix(int size) {
		this.size = size;
		matrix = new float[(size * (size + 1)) / 2];
	}

	@Override
	public float get(int first, int second) {
		final int row = Math.min(first, second);
		final int col = Math.max(first, second);
		return matrix[(row * size) - (((row * (row + 1)) / 2) - (size - col))];

	}

	@Override
	public void increaseSize(int count) throws Exception {
		throw new Exception(
				"Cannot call this function on this implementation of ITriangle Matrix");

	}

	@Override
	public void initialize(float value) {
		for (int i = 0; i < matrix.length; i++) {
			matrix[i] = value;
		}
	}

	@Override
	public void set(int first, int second, float value) {
		final int row = Math.min(first, second);
		final int col = Math.max(first, second);
		matrix[(row * size) - (((row * (row + 1)) / 2) - (size - col))] = value;
	}

	@Override
	public int size() {
		return size;
	}

	@Override
	public String toString() {
		String result = "";
		for (int i = 0; i < size; i++) {
			for (int j = 0; j < size; j++) {
				if (i < j) {
					if (Float.isInfinite(this.get(i, j))) {
						result = result + " -------";
					} else {
						result = result
								+ String.format("%+8.2f", this.get(i, j));
					}
				} else {
					result = result + ("        ");
				}
			}
			result = result + "\n";
		}
		return result;
	}
}
