//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.tasktrees.temporalrelation;

import java.util.List;

import de.ugoe.cs.autoquest.tasktrees.treeifc.IUserSession;

/**
 * <p>
 * A session scope rule is able to detected temporal relationships between task
 * instances of the sessions provided to the {@link #apply(List<IUserSession>)}
 * method. The rule creates temporal relationships between the tasks of the task
 * instances, i.e. substructures in the task tree, if it detects a temporal
 * relationship and instantiates the temporal relationships according to their
 * occurrences.
 * </p>
 * 
 * @author Patrick Harms
 */
interface ISessionScopeRule extends ITemporalRelationshipRule {

	/**
	 * <p>
	 * Applies the rule to the given sessions. The returned rule application
	 * result is null, if the rule can not be applied, i.e. it does not detect a
	 * temporal relationship. It returns a rule application result with a status
	 * {@link RuleApplicationStatus#RULE_APPLICATION_FINISHED} if the rule was
	 * applied. The result contains all newly created tasks and task instances.
	 * </p>
	 * 
	 * @param sessions
	 *            the session on which the rule shall be applied
	 * 
	 * @return the rule application result as described.
	 */
	RuleApplicationResult apply(List<IUserSession> sessions);

}
