//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.tasktrees.treeifc;

/**
 * <p>
 * Default implementation for a task instance visitor performing a traversal of
 * the instances
 * </p>
 * 
 * @author Patrick Harms
 */
public class DefaultTaskInstanceTraversingVisitor implements
		ITaskInstanceVisitor {

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskInstanceVisitor#visit(
	 * IEventTaskInstance)
	 */
	@Override
	public void visit(IEventTaskInstance eventTaskInstance) {
		// do nothing
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskInstanceVisitor#visit(
	 * IIterationInstance)
	 */
	@Override
	public void visit(IIterationInstance iterationInstance) {
		visit((ITaskInstanceList) iterationInstance);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskInstanceVisitor#visit(
	 * IOptionalInstance)
	 */
	@Override
	public void visit(IOptionalInstance optionalInstance) {
		if (optionalInstance.getChild() != null) {
			optionalInstance.getChild().accept(this);
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskInstanceVisitor#visit(
	 * ISelectionInstance)
	 */
	@Override
	public void visit(ISelectionInstance selectionInstance) {
		selectionInstance.getChild().accept(this);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskInstanceVisitor#visit(
	 * ISequenceInstance)
	 */
	@Override
	public void visit(ISequenceInstance sequenceInstance) {
		visit((ITaskInstanceList) sequenceInstance);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskInstanceVisitor#visit(
	 * ITaskInstance)
	 */
	@Override
	public void visit(ITaskInstance taskInstance) {
		if (taskInstance instanceof IEventTaskInstance) {
			visit((IEventTaskInstance) taskInstance);
		} else if (taskInstance instanceof IIterationInstance) {
			visit((IIterationInstance) taskInstance);
		} else if (taskInstance instanceof IOptionalInstance) {
			visit((IOptionalInstance) taskInstance);
		} else if (taskInstance instanceof ISelectionInstance) {
			visit((ISelectionInstance) taskInstance);
		} else if (taskInstance instanceof ISequenceInstance) {
			visit((ISequenceInstance) taskInstance);
		}
	}

	/**
	 * <p>
	 * common implementation for traversing task instance lists.
	 * </p>
	 * 
	 * @param taskInstanceList
	 *            the task instance list to be traversed
	 */
	public void visit(ITaskInstanceList taskInstanceList) {
		for (final ITaskInstance child : taskInstanceList) {
			child.accept(this);
		}
	}
}
