//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.tasktrees.treeifc;

/**
 * <p>
 * This temporal relationship defines that its single child may or may not be
 * executed for fulfilling the task. This is most important for the parent node
 * in the task model as this node may require that a specific subtask is
 * optional.
 * </p>
 * 
 * @author Patrick Harms
 */
public interface IOptional extends IMarkingTemporalRelationship {

	/**
	 * <p>
	 * returns an exact copy of this temporal relationship. The clone has the
	 * same id. Its child is a clone of the child of the cloned task. A call on
	 * the method {@link #equals(ITask)} with the result of this method must
	 * return true.
	 * </p>
	 * 
	 * @return as described
	 */
	@Override
	public IOptional clone();

}
