//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.tasktrees.treeimpl;

import java.util.List;

import de.ugoe.cs.autoquest.eventcore.Event;
import de.ugoe.cs.autoquest.tasktrees.treeifc.IEventTask;
import de.ugoe.cs.autoquest.tasktrees.treeifc.IEventTaskInstance;
import de.ugoe.cs.autoquest.tasktrees.treeifc.IIteration;
import de.ugoe.cs.autoquest.tasktrees.treeifc.IIterationInstance;
import de.ugoe.cs.autoquest.tasktrees.treeifc.IOptional;
import de.ugoe.cs.autoquest.tasktrees.treeifc.IOptionalInstance;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ISelection;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ISelectionInstance;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ISequence;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ISequenceInstance;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskModel;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskFactory;
import de.ugoe.cs.autoquest.tasktrees.treeifc.IUserSession;

/**
 * <p>
 * this is the default implementation of the interface {@link ITaskFactory}. It
 * does not do anything fancy except implementing the interface. It instantiates
 * the other implementations of the tree ifc in this package.
 * </p>
 * 
 * @author Patrick Harms
 */
public class TaskFactory implements ITaskFactory {

	/*
	 * (non-Javadoc)
	 * 
	 * @see ITaskFactory#createNewEventTask(String)
	 */
	@Override
	public IEventTask createNewEventTask(String description) {
		return new EventTask(description);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see ITaskFactory#createNewIteration()
	 */
	@Override
	public IIteration createNewIteration() {
		return new Iteration();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see ITaskFactory#createNewOptional()
	 */
	@Override
	public IOptional createNewOptional() {
		return new Optional();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see ITaskFactory#createNewSelection()
	 */
	@Override
	public ISelection createNewSelection() {
		return new Selection();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see ITaskFactory#createNewSequence()
	 */
	@Override
	public ISequence createNewSequence() {
		return new Sequence();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see ITaskFactory#createNewTaskInstance(IEventTask, Event)
	 */
	@Override
	public IEventTaskInstance createNewTaskInstance(IEventTask task, Event event) {
		if (!(task instanceof EventTask)) {
			throw new IllegalArgumentException(
					"illegal type of event task provided: " + task.getClass());
		}

		final EventTaskInstance instance = new EventTaskInstance(task, event);
		((EventTask) task).addInstance(instance);

		return instance;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see ITaskFactory#createNewTaskInstance(IIteration)
	 */
	@Override
	public IIterationInstance createNewTaskInstance(IIteration iteration) {
		if (!(iteration instanceof Iteration)) {
			throw new IllegalArgumentException(
					"illegal type of iteration provided: "
							+ iteration.getClass());
		}

		final IterationInstance instance = new IterationInstance(iteration);
		((Iteration) iteration).addInstance(instance);

		return instance;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see ITaskFactory#createNewTaskInstance(IOptional)
	 */
	@Override
	public IOptionalInstance createNewTaskInstance(IOptional optional) {
		if (!(optional instanceof Optional)) {
			throw new IllegalArgumentException(
					"illegal type of optional provided: " + optional.getClass());
		}

		final OptionalInstance instance = new OptionalInstance(optional);
		((Optional) optional).addInstance(instance);

		return instance;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see ITaskFactory#createNewTaskInstance(ISelection)
	 */
	@Override
	public ISelectionInstance createNewTaskInstance(ISelection selection) {
		if (!(selection instanceof Selection)) {
			throw new IllegalArgumentException(
					"illegal type of optional provided: "
							+ selection.getClass());
		}

		final SelectionInstance instance = new SelectionInstance(selection);
		((Selection) selection).addInstance(instance);

		return instance;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see ITaskFactory#createNewTaskInstance(ISequence)
	 */
	@Override
	public ISequenceInstance createNewTaskInstance(ISequence sequence) {
		if (!(sequence instanceof Sequence)) {
			throw new IllegalArgumentException(
					"illegal type of sequence provided: " + sequence.getClass());
		}

		final SequenceInstance instance = new SequenceInstance(sequence);
		((Sequence) sequence).addInstance(instance);

		return instance;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see ITaskFactory#createTaskModel(List<IUserSession>)
	 */
	@Override
	public ITaskModel createTaskModel(List<IUserSession> userSessions) {
		return new TaskModel(userSessions);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see ITaskFactory#createUserSession()
	 */
	@Override
	public IUserSession createUserSession() {
		return new UserSession();
	}

}
