/**
 * 
 */
package de.ugoe.cs.autoquest.tasktrees.alignment.matrix;

import java.util.HashSet;
import java.util.LinkedList;

import de.ugoe.cs.autoquest.tasktrees.treeifc.ITask;

/**
 * @author Ralph Krimmel
 *
 */
public class DifferenceSubstitutionMatrix implements SubstitutionMatrix {

	private final int[] input1;
	private final int[] input2;
	private final int maxValue;

	public DifferenceSubstitutionMatrix(int[] input1, int[] input2) {
		this.input1 = input1;
		this.input2 = input2;
		this.maxValue = getMaxValue();
	}

	@Override
	public void generate(HashSet<ITask> uniqueTasks) {
	}

	@Override
	public float getGapPenalty() {
		return -maxValue;
	}

	private int getMaxValue() {
		int max = input1[0];
		for (int i = 0; i < input1.length; i++) {
			if (input1[i] > max) {
				max = input1[i];
			}
		}
		for (int j = 0; j < input2.length; j++) {
			if (input2[j] > max) {
				max = input2[j];
			}
		}
		return max;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * de.ugoe.cs.autoquest.plugin.alignment.SubstitutionMatrix#getDistance(int,
	 * int)
	 */
	@Override
	public float getScore(int pos1, int pos2) {
		return maxValue - (input1[pos1] - input2[pos2]);
	}

	@Override
	public void update(LinkedList<ITask> newlyGeneratedTasks) {
	}

}
