package de.ugoe.cs.autoquest.tasktrees.alignment.matrix;

import java.util.LinkedList;

import de.ugoe.cs.autoquest.tasktrees.treeifc.DefaultTaskTraversingVisitor;
import de.ugoe.cs.autoquest.tasktrees.treeifc.IEventTask;
import de.ugoe.cs.autoquest.tasktrees.treeifc.IEventTaskInstance;

public class EventTaskInstancesListGenerator extends
		DefaultTaskTraversingVisitor {

	private LinkedList<IEventTaskInstance> eventlist;

	public EventTaskInstancesListGenerator() {
		eventlist = new LinkedList<IEventTaskInstance>();
	}

	public LinkedList<IEventTaskInstance> getEventlist() {
		return eventlist;
	}

	public void setEventlist(LinkedList<IEventTaskInstance> eventlist) {
		this.eventlist = eventlist;
	}

	@Override
	public void visit(IEventTask eventTask) {
		if (eventTask.getInstances().size() > 0) {
			final IEventTaskInstance eti = (IEventTaskInstance) eventTask
					.getInstances().iterator().next();
			// System.out.println("Adding eventtaskinstance to list: " + eti);
			eventlist.add(eti);
		}
	}

}
