//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.tasktrees.treeifc;

import java.io.Serializable;

/**
 * <p>
 * a task instance represents the execution of a specific task within a user
 * session. A task instance is always related to the task that was executed.
 * </p>
 * 
 * @author Patrick Harms
 */
public interface ITaskInstance extends Serializable, Cloneable {

	/**
	 * <p>
	 * implements the visitor pattern to be able to process task instances and
	 * their children.
	 * </p>
	 * 
	 * @param visitor
	 *            the visitor used to process the task
	 */
	public void accept(ITaskInstanceVisitor visitor);

	/**
	 * <p>
	 * clones a task instance by creating exact clones of each contained child
	 * instance as well as the related task. Furthermore, all other non
	 * transient information of the task instance must be cloned.
	 * </p>
	 * 
	 * @return a clone of the task instance
	 */
	public ITaskInstance clone();

	/**
	 * <p>
	 * compares an instance to another one. Returns true if both instances are
	 * the same, i.e. not only the related task is equal but also all children
	 * and further characteristics of the task instance
	 * </p>
	 * 
	 * @param taskInstance
	 *            the instance to compare to
	 * 
	 * @return as described
	 */
	public boolean equals(ITaskInstance taskInstance);

	/**
	 * <p>
	 * returns the task related to the instance.
	 * </p>
	 * 
	 * @return as described
	 */
	public ITask getTask();

	/**
	 * <p>
	 * returns a hash code for the task instance to be able to put it into hash
	 * maps
	 * </p>
	 * 
	 * @return as described
	 */
	@Override
	public int hashCode();

}
