//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.tasktrees.treeifc;

/**
 * <p>
 * A temporal relationship is a node in a task model which is no leaf node. They
 * are used to structure the tasks in a task model into useful orders. A
 * temporal relationship defines through its type how its children can be
 * executed to fulfill the task they represent themselves. E.g., the task of
 * filling out a form can be subdivided into several subtasks for filling out
 * the different elements of the. The task itself will define the order, in
 * which the fill out process can and must be done.
 * </p>
 * 
 * @author Patrick Harms
 */
public interface ITemporalRelationship extends ITask {

	/**
	 * <p>
	 * returns an exact copy of this temporal relationship. The clone has the
	 * same id. Its children are clones of the children of the cloned task. A
	 * call on the method {@link #equals(ITask)} with the result of this method
	 * must return true.
	 * </p>
	 * 
	 * @return as described
	 */
	@Override
	public ITemporalRelationship clone();

}
