/**
 * 
 */
package de.ugoe.cs.autoquest.tasktrees.alignment.matrix;

import java.util.HashSet;
import java.util.LinkedList;

import de.ugoe.cs.autoquest.tasktrees.treeifc.ITask;

// TODO: Auto-generated Javadoc
/**
 * The Class DifferenceSubstitutionMatrix.
 *
 * @author Ralph Krimmel
 */
public class DifferenceSubstitutionMatrix implements SubstitutionMatrix {

	/** The input1. */
	private final int[] input1;
	
	/** The input2. */
	private final int[] input2;
	
	/** The max value. */
	private final int maxValue;

	/**
	 * Instantiates a new difference substitution matrix.
	 *
	 * @param input1 the input1
	 * @param input2 the input2
	 */
	public DifferenceSubstitutionMatrix(int[] input1, int[] input2) {
		this.input1 = input1;
		this.input2 = input2;
		this.maxValue = getMaxValue();
	}

	/* (non-Javadoc)
	 * @see de.ugoe.cs.autoquest.tasktrees.alignment.matrix.SubstitutionMatrix#generate(java.util.HashSet)
	 */
	@Override
	public void generate(HashSet<ITask> uniqueTasks) {
	}

	/* (non-Javadoc)
	 * @see de.ugoe.cs.autoquest.tasktrees.alignment.matrix.SubstitutionMatrix#getGapPenalty()
	 */
	@Override
	public float getGapPenalty() {
		return -maxValue;
	}

	/**
	 * Gets the max value.
	 *
	 * @return the max value
	 */
	private int getMaxValue() {
		int max = input1[0];
		for (int i = 0; i < input1.length; i++) {
			if (input1[i] > max) {
				max = input1[i];
			}
		}
		for (int j = 0; j < input2.length; j++) {
			if (input2[j] > max) {
				max = input2[j];
			}
		}
		return max;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * de.ugoe.cs.autoquest.plugin.alignment.SubstitutionMatrix#getDistance(int,
	 * int)
	 */
	@Override
	public float getScore(int pos1, int pos2) {
		return maxValue - (input1[pos1] - input2[pos2]);
	}

	/* (non-Javadoc)
	 * @see de.ugoe.cs.autoquest.tasktrees.alignment.matrix.SubstitutionMatrix#update(java.util.LinkedList)
	 */
	@Override
	public void update(LinkedList<ITask> newlyGeneratedTasks) {
	}

}
