/*
 * 
 */
package de.ugoe.cs.autoquest.tasktrees.alignment.matrix;

// TODO: Auto-generated Javadoc
/**
 * The Class UPGMAMatrix.
 */
public class UPGMAMatrix extends StaticTriangleMatrix {

	/**
	 * Instantiates a new UPGMA matrix.
	 *
	 * @param size the size
	 */
	public UPGMAMatrix(int size) {
		super(size);
	}

	/* (non-Javadoc)
	 * @see de.ugoe.cs.autoquest.tasktrees.alignment.matrix.StaticTriangleMatrix#size()
	 */
	@Override
	public int size() {
		return size;
	}

	/* (non-Javadoc)
	 * @see de.ugoe.cs.autoquest.tasktrees.alignment.matrix.StaticTriangleMatrix#toString()
	 */
	@Override
	public String toString() {
		String result = "";
		for (int i = 0; i < size; i++) {
			result = result + String.format("%8d", i);
		}
		result += "\n";

		for (int i = 0; i < size; i++) {
			for (int j = 0; j < size; j++) {
				if (i < j) {
					if (Double.isInfinite(this.get(i, j))) {
						result = result + " -------";
					} else {
						result = result
								+ String.format("%+8.2f", this.get(i, j));
					}
				} else {
					result = result + ("        ");
				}
			}
			result = result + "   " + i + "\n";
		}
		return result;
	}

}
