/*
 * 
 */
package de.ugoe.cs.autoquest.tasktrees.alignment.algorithms;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;

// TODO: Auto-generated Javadoc
/**
 * The Class Match.
 */
public class Match implements Serializable {
	
	/** The Constant serialVersionUID. */
	private static final long serialVersionUID = -3206992723755714741L;

	/** The matchseqs. */
	private final ArrayList<NumberSequence> matchseqs;

	/** The occurences. */
	private LinkedList<MatchOccurence> occurences;

	/**
	 * Instantiates a new match.
	 */
	public Match() {
		matchseqs = new ArrayList<NumberSequence>(2);
		occurences = new LinkedList<MatchOccurence>();
		matchseqs.add(null);
		matchseqs.add(null);
	}

	/**
	 * Adds the occurence.
	 *
	 * @param occurence the occurence
	 */
	public void addOccurence(MatchOccurence occurence) {
		occurences.add(occurence);
	}

	/**
	 * Adds the occurences of.
	 *
	 * @param m the m
	 */
	public void addOccurencesOf(Match m) {
		occurences.addAll(m.getOccurences());
	}

	/**
	 * Equals.
	 *
	 * @param m the m
	 * @return true, if successful
	 */
	public boolean equals(Match m) {
		if ((m.getFirstSequence().equals(this.getFirstSequence()) || m
				.getFirstSequence().equals(this.getSecondSequence()))
				&& (m.getSecondSequence().equals(this.getFirstSequence()) || m
						.getSecondSequence().equals(this.getSecondSequence()))) {
			return true;
		}
		return false;
	}

	/**
	 * Gets the first sequence.
	 *
	 * @return the first sequence
	 */
	public NumberSequence getFirstSequence() {
		return matchseqs.get(0);
	}

	/**
	 * Gets the occurences.
	 *
	 * @return the occurences
	 */
	public LinkedList<MatchOccurence> getOccurences() {
		return occurences;
	}

	/**
	 * Gets the second sequence.
	 *
	 * @return the second sequence
	 */
	public NumberSequence getSecondSequence() {
		return matchseqs.get(1);
	}

	/**
	 * Occurence count.
	 *
	 * @return the int
	 */
	public int occurenceCount() {
		return occurences.size();
	}

	/**
	 * Sets the first sequence.
	 *
	 * @param seq the new first sequence
	 */
	public void setFirstSequence(NumberSequence seq) {
		matchseqs.set(0, seq);
	}

	/**
	 * Sets the occurences.
	 *
	 * @param occurences the new occurences
	 */
	public void setOccurences(LinkedList<MatchOccurence> occurences) {
		this.occurences = occurences;
	}

	/**
	 * Sets the second sequence.
	 *
	 * @param seq the new second sequence
	 */
	public void setSecondSequence(NumberSequence seq) {
		matchseqs.set(1, seq);
	}

	/**
	 * Size.
	 *
	 * @return the int
	 */
	public int size() {
		// Both sequences should be equally long
		return matchseqs.get(0).size();
	}

}
