/**
 * 
 */
package de.ugoe.cs.autoquest.tasktrees.alignment.matrix;

import java.util.HashSet;
import java.util.LinkedList;

import de.ugoe.cs.autoquest.tasktrees.treeifc.ITask;

// TODO: Auto-generated Javadoc
/**
 * The Class NearbySubstitutionMatrix.
 *
 * @author Ralph Krimmel
 */
public class NearbySubstitutionMatrix implements SubstitutionMatrix {

	/** The input1. */
	private final int[] input1;
	
	/** The input2. */
	private final int[] input2;
	
	/** The range. */
	private final int range;

	/**
	 * Instantiates a new nearby substitution matrix.
	 *
	 * @param input1 the input1
	 * @param input2 the input2
	 * @param range the range
	 */
	public NearbySubstitutionMatrix(int[] input1, int[] input2, int range) {
		this.input1 = input1;
		this.input2 = input2;
		this.range = range;
	}

	/* (non-Javadoc)
	 * @see de.ugoe.cs.autoquest.tasktrees.alignment.matrix.SubstitutionMatrix#generate(java.util.HashSet)
	 */
	@Override
	public void generate(HashSet<ITask> uniqueTasks) {
	}

	/* (non-Javadoc)
	 * @see de.ugoe.cs.autoquest.tasktrees.alignment.matrix.SubstitutionMatrix#getGapPenalty()
	 */
	@Override
	public float getGapPenalty() {
		return -range - 1;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * de.ugoe.cs.autoquest.plugin.alignment.SubstitutionMatrix#getDistance(int,
	 * int)
	 */
	@Override
	public float getScore(int pos1, int pos2) {
		final int difference = Math.abs(input1[pos1] - input2[pos2]);
		if (difference < range) {
			return range - difference;
		} else {
			return -range;
		}
	}

	/* (non-Javadoc)
	 * @see de.ugoe.cs.autoquest.tasktrees.alignment.matrix.SubstitutionMatrix#update(java.util.LinkedList)
	 */
	@Override
	public void update(LinkedList<ITask> newlyGeneratedTasks) {
	}

}
