//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.tasktrees.temporalrelation;

import de.ugoe.cs.autoquest.tasktrees.treeifc.IMarkingTemporalRelationship;
import de.ugoe.cs.autoquest.tasktrees.treeifc.IStructuringTemporalRelationship;
import de.ugoe.cs.autoquest.tasktrees.treeifc.IOptional;
import de.ugoe.cs.autoquest.tasktrees.treeifc.IOptionalInstance;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ISelection;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ISelectionInstance;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ISequence;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ISequenceInstance;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITask;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskBuilder;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskInstance;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskInstanceList;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskFactory;

/**
 * <p>
 * provides some convenience methods for rule application
 * </p>
 * .
 *
 * @author Patrick Harms, Ralph Krimmel
 */
class RuleUtils {

	/**
	 * <p>
	 * replaces a sub sequence for a specified range of elements in the provided
	 * task instances list by a sub task instance
	 * </p>
	 * .
	 *
	 * @param parent
	 *            the list of which the range shall be replaced
	 * @param startIndex
	 *            the start index of the range
	 * @param endIndex
	 *            the end index of the range (inclusive)
	 * @param model
	 *            the task model (required for instantiating the sub sequence)
	 * @param taskFactory
	 *            the task factory used for instantiating the sub sequence
	 * @param taskBuilder
	 *            the task builder to perform changes in the task structure
	 * @return the replacement for the range
	 */
	static synchronized ISequenceInstance createNewSubSequenceInRange(
			ITaskInstanceList parent, int startIndex, int endIndex,
			ISequence model, ITaskFactory taskFactory, ITaskBuilder taskBuilder) {
		final ISequenceInstance subsequence = taskFactory
				.createNewTaskInstance(model);
		/*
		System.out.println("PRINTING MODEL: ");
		for (int i = 0; i < subsequence.getSequence().getChildren().size(); i++) {
			System.out.println(subsequence.getSequence().getChildren().get(i));

			if (subsequence.getSequence().getChildren().get(i).getType() == "selection") {
				for (int j = 0; j < ((ISelection) subsequence.getSequence()
						.getChildren().get(i)).getChildren().size(); j++) {
					if (((IStructuringTemporalRelationship) subsequence
							.getSequence().getChildren().get(i)).getChildren()
							.get(j).getType() == "sequence") {
						ISequence foo = (ISequence) ((ISelection) (subsequence
								.getSequence().getChildren().get(i)))
								.getChildren().get(j);
						System.out.println("\t" + foo);
						for (int k = 0; k < foo.getChildren().size(); k++) {
							System.out.println("\t\t"
									+ foo.getChildren().get(k));
						}
						System.out.println();
					} else {
						System.out.println("\t"
								+ ((ISelection) subsequence.getSequence()
										.getChildren().get(i)).getChildren()
										.get(j));
					}

				}
			}

		}
		System.out.println();
                */
		// TODO: This is dirty, return this in addition with the sequence
		// instance instead
		missedOptionals = 0;
		int modelindex = 0;
		for (int i = startIndex; i <= endIndex; i++) {

			if (modelindex == model.getChildren().size()) {
				break;
			}
			final ITask tempTask = model.getChildren().get(modelindex);
			//System.out.println("Trying to add " + parent.get(startIndex)
			// + " to the model instance " + tempTask);
			if (tempTask.getType() == "optionality") {

				if (((IMarkingTemporalRelationship) tempTask).getMarkedTask() == parent
						.get(startIndex).getTask()) {
					// System.out.println("Adding OptionalInstance " +
					// parent.get(startIndex) + " to " + tempTask.getType());
					final IOptionalInstance optional = taskFactory
							.createNewTaskInstance((IOptional) tempTask);
					taskBuilder.setChild(optional, parent.get(startIndex));
					taskBuilder.addChild(subsequence, optional);
				} else {
					// System.out.println("Adding Empty optional, not deleting anything from the input sequence");
					final IOptionalInstance optional = taskFactory
							.createNewTaskInstance((IOptional) tempTask);
					taskBuilder.addChild(subsequence, optional);
					modelindex++;
					missedOptionals++;
					continue;
				}
			} else if (tempTask instanceof ISelection) {
				final ISelectionInstance selection = taskFactory
						.createNewTaskInstance((ISelection) tempTask);
				final ISelection tmpSel = (ISelection) tempTask;
				if (tmpSel.getChildren().size() == 0) {
					try {
						throw new Exception("Selection without children");
					} catch (Exception e) {
						e.printStackTrace();
					}
				}
				// Check if the selection has 2 sequences as children
				// TODO: This segment is a mess, clean it up.
				if ((tmpSel.getChildren().get(0) instanceof ISequence)
						&& (tmpSel.getChildren().get(1) instanceof ISequence)) {
					ISequenceInstance selseq = null;
					// The selection I create can just have 2 children, we need
					// to check here, to which sequence of the model this
					// occurence belongs
					// This if checks of the occurrence is equal to the first
					// element of the first sequence in the model
					if (parent
							.get(startIndex)
							.getTask()
							.equals(((ISequence) tmpSel.getChildren().get(0))
									.getChildren().get(0))) {
						selseq = taskFactory
								.createNewTaskInstance((ISequence) tmpSel
										.getChildren().get(0));
						for (int k = 0; k < selseq.getSequence().getChildren()
								.size(); k++) {
							taskBuilder
									.addChild(selseq, parent.get(startIndex));
							taskBuilder.removeTaskInstance(parent, startIndex);
							i++;
						}
						taskBuilder.setChild(selection, selseq);
						taskBuilder.addChild(subsequence, selection);
						modelindex++;
						continue;
					}
					// This if checks of the occurrence is equal to the first
					// element of the second sequence in the model
					else if (parent
							.get(startIndex)
							.getTask()
							.equals(((ISequence) tmpSel.getChildren().get(1))
									.getChildren().get(0))) {
						selseq = taskFactory
								.createNewTaskInstance((ISequence) tmpSel
										.getChildren().get(1));
						for (int k = 0; k < selseq.getSequence().getChildren()
								.size(); k++) {
							taskBuilder
									.addChild(selseq, parent.get(startIndex));
							taskBuilder.removeTaskInstance(parent, startIndex);
							i++;
						}
						taskBuilder.setChild(selection, selseq);
						taskBuilder.addChild(subsequence, selection);
						modelindex++;
						continue;
					}
					// If the occurrence is already a sequence wedon't need to
					// do anything, the next iteration will detect this as a
					// sequence and add it
					else if ((parent.get(startIndex).getTask().equals(tmpSel
							.getChildren().get(0)))
							|| (parent.get(startIndex).getTask().equals(tmpSel
									.getChildren().get(1)))) {
						taskBuilder.setChild(selection, parent.get(startIndex));
						taskBuilder.addChild(subsequence, selection);
						taskBuilder.removeTaskInstance(parent,startIndex);
						modelindex++;
						continue;
					}
				}
				// It is just a plain selection
				else {
					taskBuilder.setChild(selection, parent.get(startIndex));
					taskBuilder.addChild(subsequence, selection);
				}
			} else if (tempTask.getType() == "sequence") {
				taskBuilder.addChild(subsequence, parent.get(startIndex));
			} else if (tempTask.getType() == "iteration") {
				taskBuilder.addChild(subsequence, parent.get(startIndex));
			} else {
				taskBuilder.addChild(subsequence, parent.get(startIndex));
			}
			taskBuilder.removeTaskInstance(parent, startIndex);
			modelindex++;
		}

		taskBuilder.addTaskInstance(parent, startIndex, subsequence);

		return subsequence;
	}

	/**
	 * <p>
	 * returns the next available id (uses the id counter)
	 * </p>
	 * .
	 *
	 * @return the next available id
	 */
	static synchronized String getNewId() {
		return Integer.toString(idCounter++);
	}

	/**
	 * <p>
	 * generates a sub sequence for a specified range of elements in the
	 * provided task instances list.
	 * </p>
	 *
	 * @param parent
	 *            the list of which the range shall be extracted
	 * @param startIndex
	 *            the start index of the range
	 * @param endIndex
	 *            the end index of the range (inclusive)
	 * @param model
	 *            the task model (required for instantiating the sub sequence)
	 * @param taskFactory
	 *            the task factory used for instantiating the sub sequence
	 * @param taskBuilder
	 *            the task builder to perform changes in the task structure
	 * 
	 * @return a task instance representing the requested sub sequence
	 */
	static ITaskInstance getSubSequenceInRange(ITaskInstanceList parent,
			int startIndex, int endIndex, ISequence model,
			ITaskFactory taskFactory, ITaskBuilder taskBuilder) {
		final ISequenceInstance subsequence = taskFactory
				.createNewTaskInstance(model);

		for (int i = startIndex; i <= endIndex; i++) {
			taskBuilder.addChild(subsequence, parent.get(i));
		}

		return subsequence;
	}

	/**
	 * Prints the progress percentage.
	 *
	 * @param message
	 *            the message
	 * @param count
	 *            the count
	 * @param size
	 *            the size
	 */
	static void printProgressPercentage(String message, int count, int size) {
		if (size > 100) {
			if (((count % (size / 100)) == 0)) {
				// Console.traceln(Level.INFO,("Thread" +
				// Thread.currentThread().getName() + ": " + Math.round((float)
				// count/size*100))+ "%");
				// System.out.println(message + " in thread "
				// + Thread.currentThread().getName() + ": "
				// + Math.round(((float) count / size) * 100) + "%");
			}
		} else {
			// Console.traceln(Level.INFO,("Thread" +
			// Thread.currentThread().getName() + ": " +Math.round((float)
			// count/size*100))+ "%");
			// System.out.println(message + " in thread "
			// + Thread.currentThread().getName() + ": "
			// + Math.round(((float) count / size) * 100) + "%");

		}
	}

	/**
	 * <p>
	 * counter for generating unique ids. Starts at 0 for each new program start
	 * </p>
	 */
	private static int idCounter = 0;

	/** The missed optionals. */
	public static int missedOptionals = 0;

	/**
	 * <p>
	 * prevent instantiation
	 * </p>
	 * .
	 */
	private RuleUtils() {
		// prevent instantiation
	}

}
