/*
 * 
 */
package de.ugoe.cs.autoquest.tasktrees.alignment.algorithms;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.Random;

// TODO: Auto-generated Javadoc
/**
 * The Class NumberSequence.
 */
public class NumberSequence implements Serializable {
	
	/** The Constant serialVersionUID. */
	private static final long serialVersionUID = -4604570107534055589L;
	
	/** The sequence. */
	private int[] sequence;
	
	/** The id. */
	private int id;

	/**
	 * Instantiates a new number sequence.
	 *
	 * @param size the size
	 */
	public NumberSequence(int size) {

		sequence = new int[size];
	}

	// Searching occurrences of pattern
	/**
	 * Contains pattern.
	 *
	 * @param pattern the pattern
	 * @return the linked list
	 */
	public LinkedList<Integer> containsPattern(Match pattern) {
		final LinkedList<Integer> result = new LinkedList<Integer>();
		int i = 0;
		final int[] pat1 = pattern.getFirstSequence().getSequence();
		final int[] pat2 = pattern.getSecondSequence().getSequence();

		while (i < sequence.length) {
			if (matches(i, pat1, pat2, 0, 0, false, false, false, false, false)) {
				result.add(i);
			}
			i++;
		}
		return result;
	}

	/**
	 * Equals.
	 *
	 * @param n the n
	 * @return true, if successful
	 */
	public boolean equals(NumberSequence n) {
		final int[] seq = n.getSequence();
		if (n.size() != this.size()) {
			return false;
		}
		for (int i = 0; i < n.size(); i++) {
			if (seq[i] != this.sequence[i]) {
				return false;
			}
		}
		return true;
	}

	// Returns the number of times event occurs in this sequence
	/**
	 * Event count.
	 *
	 * @param event the event
	 * @return the int
	 */
	public int eventCount(int event) {
		int count = 0;
		for (int i = 0; i < sequence.length; i++) {
			if (sequence[i] == event) {
				count++;
			}
		}
		return count;
	}

	/**
	 * Gets the id.
	 *
	 * @return the id
	 */
	public int getId() {
		return id;
	}

	/**
	 * Gets the sequence.
	 *
	 * @return the sequence
	 */
	public int[] getSequence() {
		return sequence;
	}

	// Recursive check if sequence contains pattern at position i
	/**
	 * Matches.
	 *
	 * @param i the i
	 * @param p1 the p1
	 * @param p2 the p2
	 * @param ip1 the ip1
	 * @param ip2 the ip2
	 * @param jumped1 the jumped1
	 * @param jumped2 the jumped2
	 * @param hadSelection the had selection
	 * @param matchseq1 the matchseq1
	 * @param matchseq2 the matchseq2
	 * @return true, if successful
	 */
	private boolean matches(int i, int[] p1, int[] p2, int ip1, int ip2,
			boolean jumped1, // True if there was a gap in Sequence 1 of the
								// pattern
			boolean jumped2, // True if there was a gap in Sequence 2 of the
								// pattern
			boolean hadSelection, // True if the last match was a selection
			boolean matchseq1, boolean matchseq2) {

		if (p1.length == ip1) {
			return true;
		}
		if (p2.length == ip2) {
			return true;
		}
		if (i == sequence.length) {
			return false;
		}

		final boolean foundselection = (!(p1[ip1] == p2[ip2]) && !((p1[ip1] == -1) || (p2[ip2] == -1)));
		final boolean matchInFirstPattern = (p1[ip1] == sequence[i]);
		final boolean matchInSecondPattern = (p2[ip2] == sequence[i]);

		if (foundselection && hadSelection) {
			if ((matchInFirstPattern && matchseq1)
					|| (matchInSecondPattern && matchseq2)) {
				if (jumped1) {
					return matches(i + 1, p1, p2, ip1 + 1, ip2 + 2, false,
							false, foundselection, matchInFirstPattern,
							matchInSecondPattern);
				}
				if (jumped2) {
					return matches(i + 1, p1, p2, ip1 + 2, ip2 + 1, false,
							false, foundselection, matchInFirstPattern,
							matchInSecondPattern);
				}
				return matches(i + 1, p1, p2, ip1 + 1, ip2 + 1, false, false,
						foundselection, matchInFirstPattern,
						matchInSecondPattern);
			} else {
				return false;
			}
		}

		if ((matchInFirstPattern || matchInSecondPattern) && jumped1) {
			return matches(i + 1, p1, p2, ip1 + 1, ip2 + 2, false, false,
					foundselection, matchInFirstPattern, matchInSecondPattern);
		}
		if ((matchInFirstPattern || matchInSecondPattern) && jumped2) {
			return matches(i + 1, p1, p2, ip1 + 2, ip2 + 1, false, false,
					foundselection, matchInFirstPattern, matchInSecondPattern);
		}
		if (matchInFirstPattern || matchInSecondPattern) {
			return matches(i + 1, p1, p2, ip1 + 1, ip2 + 1, false, false,
					foundselection, matchInFirstPattern, matchInSecondPattern);
		}
		if (p1[ip1] == -1) {
			return matches(i, p1, p2, ip1 + 1, ip2, true, false, false, false,
					false);
		}
		if (p2[ip2] == -1) {
			return matches(i, p1, p2, ip1, ip2 + 1, false, true, false, false,
					false);
		}

		return false;
	}

	/**
	 * Prints the sequence.
	 */
	public void printSequence() {
		for (int i = 0; i < sequence.length; i++) {
			System.out.format("%5d", sequence[i]);
		}
		System.out.println();
	}

	/**
	 * Sets the id.
	 *
	 * @param id the new id
	 */
	public void setId(int id) {
		this.id = id;
	}

	/**
	 * Sets the sequence.
	 *
	 * @param sequence the new sequence
	 */
	public void setSequence(int[] sequence) {
		this.sequence = sequence;
	}

	/**
	 * Shuffle.
	 *
	 * @return the number sequence
	 */
	public NumberSequence shuffle() {
		final NumberSequence result = new NumberSequence(sequence.length);
		result.setId(getId());
		result.setSequence(this.sequence);
		final Random rgen = new Random();

		for (int i = 0; i < result.sequence.length; i++) {
			final int randomPosition = rgen.nextInt(result.sequence.length);
			final int temp = result.sequence[i];
			result.sequence[i] = result.sequence[randomPosition];
			result.sequence[randomPosition] = temp;
		}
		return result;

	}

	/**
	 * Size.
	 *
	 * @return the int
	 */
	public int size() {
		return sequence.length;
	}

}
