/*
 * 
 */
package de.ugoe.cs.autoquest.tasktrees.alignment.matrix;

import java.io.Serializable;

// TODO: Auto-generated Javadoc
/**
 * The Class StaticTriangleMatrix.
 */
public class PreallocatedDynamicTriangleMatrix implements ITriangleMatrix, Serializable {

	/** The Constant serialVersionUID. */
	private static final long serialVersionUID = 7599542322424894866L;
	
	/** The matrix. */
	private float[] matrix;
	
	/** The size. */
	protected int size;
	
	private int actualsize;
	private float initalizationValue;

	/**
	 * Instantiates a new static triangle matrix.
	 *
	 * @param size the size
	 */
	public PreallocatedDynamicTriangleMatrix(int size) {
		this.size = size;
		this.actualsize = size*10;
		matrix = new float[(actualsize * (actualsize + 1)) / 2];
	}

	/* (non-Javadoc)
	 * @see de.ugoe.cs.autoquest.tasktrees.alignment.matrix.ITriangleMatrix#get(int, int)
	 */
	@Override
	public float get(int first, int second) {
		final int row = Math.min(first, second);
		final int col = Math.max(first, second);
		return matrix[(row * actualsize) - (((row * (row + 1)) / 2) - (actualsize - col))];

	}

	/* (non-Javadoc)
	 * @see de.ugoe.cs.autoquest.tasktrees.alignment.matrix.ITriangleMatrix#increaseSize(int)
	 */
	@Override
	public void increaseSize(int count) throws Exception {
	    final int oldsize = size;
            this.size += count;
            if(size>actualsize) {
                int newElements = ((oldsize * count) + ((count * (count + 1)) / 2));
                actualsize*=2;
                float[] newmatrix = new float[actualsize];
                System.arraycopy(this.matrix, 0, newmatrix, 0,matrix.length);
                for(int i=oldsize;i<actualsize;i++) {
                    newmatrix[i]=this.initalizationValue;
                }
                matrix = newmatrix;
            }
	}

	/* (non-Javadoc)
	 * @see de.ugoe.cs.autoquest.tasktrees.alignment.matrix.ITriangleMatrix#initialize(float)
	 */
	@Override
	public void initialize(float value) {
	        this.initalizationValue = value;
		for (int i = 0; i < matrix.length; i++) {
			matrix[i] = value;
		}
	}

	/* (non-Javadoc)
	 * @see de.ugoe.cs.autoquest.tasktrees.alignment.matrix.ITriangleMatrix#set(int, int, float)
	 */
	@Override
	public void set(int first, int second, float value) {
		final int row = Math.min(first, second);
		final int col = Math.max(first, second);
		matrix[(row * actualsize) - (((row * (row + 1)) / 2) - (actualsize - col))] = value;
	}

	/* (non-Javadoc)
	 * @see de.ugoe.cs.autoquest.tasktrees.alignment.matrix.ITriangleMatrix#size()
	 */
	@Override
	public int size() {
		return size;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		String result = "";
		for (int i = 0; i < actualsize; i++) {
			for (int j = 0; j < actualsize; j++) {
				if (i < j) {
					if (Float.isInfinite(this.get(i, j))) {
						result = result + " -------";
					} else {
						result = result
								+ String.format("%+8.2f", this.get(i, j));
					}
				} else {
					result = result + ("        ");
				}
			}
			result = result + "\n";
		}
		return result;
	}
}
