package de.ugoe.cs.autoquest.plugin.android.guimodel;

import de.ugoe.cs.autoquest.eventcore.guimodel.IGUIElementSpec;

/**
 * <p>
 * Implements the specification of {@link IGUIElement} for
 * {@link AndroidGUIElement}s.
 * </p>
 * 
 * @version 1.0
 * @author Florian Unger
 */
public class AndroidGUIElementSpec implements IGUIElementSpec {

	// TODO Why is serialVersionUID = 1L initialized by 1L?
	/**
	 * <p>
	 * default serial version UID
	 * </p>
	 */
	private static final long serialVersionUID = 1L;

	/*
	 * (non-Javadoc) see
	 * de.ugoe.cs.autoquest.androidmonitor.AndroidmonitorLogFile logComponent()
	 */
	/**
	 * <p>
	 * Hash code of the GUI element. Used as unique identifier during parsing a
	 * log file. Note that it is possible that the hash code of an element
	 * changes over several log files even if they come from the same target.
	 * </p>
	 */
	private int hashCode;

	/**
	 * <p>
	 * Path to an element in an activity. e.g. a path of a button could look
	 * like MainActivity/DecorView/ActionBarOverlayLayout/FrameLayout/
	 * RelativeLayout/Button
	 * </p>
	 */
	private String path;

	/**
	 * <p>
	 * the type of GUI element represented by this specification, which is
	 * usually the java class of the android GUI element
	 * </p>
	 */
	private String type;

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.autoquest.eventcore.guimodel.IGUIElementSpec#getType()
	 */
	@Override
	public String getType() {
		return type;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * de.ugoe.cs.autoquest.eventcore.guimodel.IGUIElementSpec#getTypeHierarchy
	 * ()
	 */
	@Override
	public String[] getTypeHierarchy() {
		return new String[] { (getType()) };
		// TODO change this part after adding ancestors in
		// de.ugoe.cs.autoquest.androidmonitor.AndroidmonitorLogFile#addComponent
	}

	@Override
	public boolean getSimilarity(IGUIElementSpec other) {
		if (this == other) {
			return true;
		}

		if (!(other instanceof AndroidGUIElementSpec)) {
			return false;
		}

		// Check wheter view.id() keeps the same even if something in the
		// structure changes. The hash in the JFCMonitor seems to be unique at
		// all. In the Androidmonitore the hash of an element changes even from
		// one start of the activity to another.
		/*
		 * Maybe some other comparisons will be necessary in the future.
		 */

		return false;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode() {
		return hashCode;
	}

	/**
	 * <p>
	 * Returns the path associated with the specified GUI element.
	 * </p>
	 * @return the path to an element
	 */
	public String getPath() {
		return path;
	}

	/**
	 * Set the path associated with the specified GUI element.
	 * @param path
	 * 				the path to an element
	 */
	public void setPath(String path) {
		this.path = path;
	}

}
