/*
 * 
 */
package de.ugoe.cs.autoquest.tasktrees.alignment.algorithms;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;

// TODO: Auto-generated Javadoc
/**
 * The Class Match.
 */
public class Match implements Cloneable,Comparable<Match>,Serializable {
	
	/** The Constant serialVersionUID. */
	private static final long serialVersionUID = -3206992723755714741L;

	/** The matchseqs. */
	private final ArrayList<NumberSequence> matchseqs;

	/** The occurences. */
	private LinkedList<MatchOccurrence> occurrences;

	/**
	 * Instantiates a new match.
	 */
	public Match() {
		matchseqs = new ArrayList<NumberSequence>(2);
		occurrences = new LinkedList<MatchOccurrence>();
		matchseqs.add(null);
		matchseqs.add(null);
	}		// TODO Auto-generated method stub

	/**
	 * Adds the occurence.
	 *
	 * @param occurence the occurence
	 */
	public void addOccurence(MatchOccurrence occurence) {
		occurrences.add(occurence);
	}

	/**
	 * Adds the occurrences of given match to this match .
	 *
	 * @param m the match the occurrences should be merged with this one
	 */
	public void addOccurencesOf(Match m) {
		occurrences.addAll(m.getOccurences());
	}

	/**
	 * Equals.
	 *
	 * @param m the Match the equality should be checked against
	 * @return true, if both Matches are equal
	 */
	public boolean equals(Match m) {
		if ((m.getFirstSequence().equals(this.getFirstSequence()) || m
				.getFirstSequence().equals(this.getSecondSequence()))
				&& (m.getSecondSequence().equals(this.getFirstSequence()) || m
						.getSecondSequence().equals(this.getSecondSequence()))) {
			return true;
		}
		return false;
	}

	/**
	 * Gets the first sequence.
	 *
	 * @return the first sequence
	 */
	public NumberSequence getFirstSequence() {
		return matchseqs.get(0);
	}

	/**
	 * Gets the occurrences.
	 *
	 * @return the occurrences
	 */
	public LinkedList<MatchOccurrence> getOccurences() {
		return occurrences;
	}

	/**
	 * Gets the second sequence.
	 *
	 * @return the second sequence
	 */
	public NumberSequence getSecondSequence() {
		return matchseqs.get(1);
	}

	/**
	 * Occurrence count.
	 *
	 * @return the number of occurrences of this match
	 */
	public int occurenceCount() {
		return occurrences.size();
	}

	/**
	 * Sets the first sequence.
	 *
	 * @param seq the new first sequence
	 */
	public void setFirstSequence(NumberSequence seq) {
		matchseqs.set(0, seq);
	}

	/**
	 * Sets the occurrences.
	 *
	 * @param occurences the new occurrences
	 */
	public void setOccurences(LinkedList<MatchOccurrence> occurences) {
		this.occurrences = occurences;
	}

	/**
	 * Sets the second sequence.
	 *
	 * @param seq the new second sequence
	 */
	public void setSecondSequence(NumberSequence seq) {
		matchseqs.set(1, seq);
	}


	/**
	 * Occurrence id sum. Used for comparing and sorting matches
	 *
	 * @return the sum of all occurrence ids.
	 */
	public int ocurrenceIDSum() {
		int sum = 0;
		for(Iterator<MatchOccurrence> it = occurrences.iterator();it.hasNext();) {
			MatchOccurrence mo = it.next();
			sum+=mo.getSequenceId();
		}
		return sum;
	}
	
	/**
	 * Task id sum. Used for comparing and sorting matches
	 *
	 * @return the int
	 */
	public int taskIdSum() {
		int sum = 0;
		int[] first = this.getFirstSequence().getSequence();
		int[] second = this.getSecondSequence().getSequence();
		for(int i = 0;i < this.getFirstSequence().size();i++) {
			sum= first[i]+second[i];
		}
		return sum;
	}
	
	
	
	/**
	 * Clone without occurrences.
	 *
	 * @return the match
	 * @throws CloneNotSupportedException the clone not supported exception
	 */
	public Match cloneWithoutOccurrences()   {
		Match result = new Match();
		result.setFirstSequence(this.getFirstSequence());
		result.setSecondSequence(this.getSecondSequence());
		return result;
	}
	
	
	
	/**
	 * Size.
	 *
	 * @return the size (number of aligned tasks)
	 */
	public int size() {
		// Both sequences should be equally long
		return matchseqs.get(0).size();
	}

	/* (non-Javadoc)
	 * @see java.lang.Comparable#compareTo(java.lang.Object)
	 */
	@Override
	public int compareTo(Match arg0) {
		
		return 0;
	}

}
