package de.ugoe.cs.autoquest.plugin.android.guimodel;

import de.ugoe.cs.autoquest.eventcore.guimodel.AbstractDefaultGUIElement;
import de.ugoe.cs.autoquest.eventcore.guimodel.IGUIElement;
import de.ugoe.cs.autoquest.eventcore.guimodel.IGUIElementSpec;

/**
 * <p>
 * Base class for all Android GUI elements.
 * </p>
 * 
 * @version 1.0
 * @author Florian Unger
 */
public class AndroidGUIElement extends AbstractDefaultGUIElement{

	/**
     * <p>
     * Id for object serialization.
     * </p>
     */
    private static final long serialVersionUID = 1L;
    
    /**
     * <p>
     * Specification of the GUI Element
     * </p>
     */
    private AndroidGUIElementSpec specification;
    
    /**
     * <p>
     * Constructor. Creates a new JFCGUIElement.
     * </p>
     * 
     * @param specification
     *            specification of created GUI element
     * @param parent
     *            parent of the created GUI element; null means that the element is a top-level
     *            window
     */
    public AndroidGUIElement(AndroidGUIElementSpec specification, AndroidGUIElement parent) {
		super(specification, parent);
		this.specification = specification;
	}
	
    /*
     * (non-Javadoc)
     * 
     * @see
     * de.ugoe.cs.autoquest.eventcore.guimodel.IGUIElement#updateSpecification(de.ugoe.cs.autoquest
     * .eventcore .guimodel.IGUIElementSpec)
     */
    @Override
	public void updateSpecification(IGUIElementSpec furtherSpec) {
		//nothing do do here up to now.		
	}

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.autoquest.eventcore.guimodel.IGUIElement#getDistanceTo(IGUIElement)
     */
	@Override
	public double getDistanceTo(IGUIElement otherElement) {
		throw new UnsupportedOperationException("not implemented yet");
	}
	
	/**
     * <p>
     * Returns the type of the GUI element, i.e., the name of its Java class.
     * </p>
     * 
     * @return the Java class name
     */
    public String getSpecType() {
        return specification.getType();
    }
    
    

	/*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.autoquest.eventcore.IEventTarget#getPlatform()
     */
	@Override
	public String getPlatform() {
		return "Android";
	}

	/*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
	@Override
	public String getStringIdentifier() {
		String str = this.toString();
        if (getParent() != null) {
            return str + "<-" + getParent().getStringIdentifier();
        }
        return str;
	}
	
	

}
