//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.usability;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;

import de.ugoe.cs.autoquest.tasktrees.treeifc.IMarkingTemporalRelationship;
import de.ugoe.cs.autoquest.tasktrees.treeifc.IStructuringTemporalRelationship;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITask;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskModel;
import de.ugoe.cs.util.console.Console;

/**
 * TODO comment
 * 
 * @version $Revision: $ $Date: 16.07.2012$
 * @author 2012, last modified by $Author: pharms$
 */
public class UsabilityEvaluationManager {
    
    /** */
    private List<UsabilityEvaluationRule> rules = new ArrayList<UsabilityEvaluationRule>();

    /**
     * 
     */
    public UsabilityEvaluationManager() {
        super();
        init();
    }

    /**
     * 
     */
    private void init() {
        //rules.add(new TextInputStatisticsRule());
        rules.add(new MissingFeedbackRule());
        rules.add(new EventCoverageRatioRule());
        rules.add(new RequiredInefficientActionsRule());
        //rules.add(new TaskCooccurrenceRule());
        rules.add(new TargetDistanceRule());
        //rules.add(new UnusedGUIElementsRule());
        //rules.add(new TaskTreeTestRule());
    }

    /**
     *
     */
    public UsabilityEvaluationResult evaluateUsability(ITaskModel taskModel) {
        Console.traceln(Level.INFO, "evaluating usability of task model " + taskModel);

        List<UsabilityEvaluationResult> interimResults = new ArrayList<UsabilityEvaluationResult>();

        for (UsabilityEvaluationRule rule : rules) {
            Console.traceln(Level.INFO, "applying rule " + rule.getClass().getSimpleName());
            UsabilityEvaluationResult result = rule.evaluate(taskModel);
            interimResults.add(result);
            Console.traceln(Level.INFO, "the rule found " + result.getAllDefects().size() +
                            " usability defects, of which " + result.getSevereDefects().size() +
                            " are severe.");
            
            if ((rule instanceof EventCoverageRatioRule) ||
                (rule instanceof RequiredInefficientActionsRule) ||
                (rule instanceof TargetDistanceRule))
            {
                ITask[] referredTasks = new ITask[result.getAllDefects().size()];

                for (int i = 0; i < result.getAllDefects().size(); i++) {
                    referredTasks[i] =
                        (ITask) result.getAllDefects().get(i).getDescriptionFragments().get(1);
                }
                
                int counter = 0;
                for (int i = 0; i < referredTasks.length; i++) {
                    for (int j = 0; j < referredTasks.length; j++) {
                        if (isChildOf(referredTasks[i], referredTasks[j])) {
                            counter++;
                            break;
                        }
                    }
                }
                
                if (counter > 0) {
                    Console.traceln(Level.INFO, counter + " of the findings are duplicates in " +
                                    "that they refer to tasks whose parent tasks are also " +
                                    "referred by the findings");
                }
            }
        }

        UsabilityEvaluationResult result = new UsabilityEvaluationResult(taskModel, interimResults);
        Console.println("the evaluation result contains " + result.getAllDefects().size() +
                        " defects, of which " + result.getSevereDefects().size() + " are severe.");

        return result;
    }

    /**
     * <p>
     * TODO: comment
     * </p>
     *
     * @param iTask
     * @param iTask2
     * @return
     */
    private boolean isChildOf(final ITask potChild, ITask potParent) {
        
        if (potParent instanceof IStructuringTemporalRelationship) {
            for (ITask child : ((IStructuringTemporalRelationship) potParent).getChildren()) {
                if ((child == potChild) || isChildOf(potChild, child)) {
                    return true;
                }
            }
        }
        else if (potParent instanceof IMarkingTemporalRelationship) {
            ITask child = ((IMarkingTemporalRelationship) potParent).getMarkedTask();
            if ((child == potChild) || isChildOf(potChild, child)) {
                return true;
            }
        }
        
        return false;
    }

}
