//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.usageprofiles;

import java.util.ArrayList;
import java.util.List;
import org.junit.*;

import de.ugoe.cs.autoquest.usageprofiles.IncompleteMemory;
import static org.junit.Assert.*;

/**
 * The class <code>IncompleteMemoryTest</code> contains tests for the class <code>{@link IncompleteMemory}</code>.
 *
 * @author Steffen Herbold
 * @version 1.0
 */
public class IncompleteMemoryTest {

	@Test
	public void testIncompleteMemory_1()
		throws Exception {
		int length = 1;

		IncompleteMemory<String> result = new IncompleteMemory<String>(length);

		assertNotNull(result);
		assertEquals(0, result.getLast(1).size());
	}

	@Test(expected = java.lang.IllegalArgumentException.class)
	public void testIncompleteMemory_2()
		throws Exception {
		int length = 0;

		new IncompleteMemory<String>(length);
	}

	@Test
	public void testGetLast_1()
		throws Exception {
		int length = 2;
		IncompleteMemory<String> fixture = new IncompleteMemory<String>(length);
		fixture.add("1");
		fixture.add("2");
		fixture.add("3");
		int num = -1;

		List<String> result = fixture.getLast(num);

		assertNotNull(result);
		assertEquals(0, result.size());
	}

	@Test
	public void testGetLast_2()
		throws Exception {
		int length = 2;
		IncompleteMemory<String> fixture = new IncompleteMemory<String>(length);
		fixture.add("1");
		fixture.add("2");
		fixture.add("3");
		int num = 1;
		
		List<String> expected = new ArrayList<String>();
		expected.add("3");

		List<String> result = fixture.getLast(num);

		assertNotNull(result);
		assertEquals(expected, result);
	}

	@Test
	public void testGetLast_3()
		throws Exception {
		int length = 2;
		IncompleteMemory<String> fixture = new IncompleteMemory<String>(length);
		fixture.add("1");
		fixture.add("2");
		fixture.add("3");
		int num = 2;
		
		List<String> expected = new ArrayList<String>();
		expected.add("2");
		expected.add("3");

		List<String> result = fixture.getLast(num);

		assertNotNull(result);
		assertEquals(expected, result);
	}
	
	@Test
	public void testGetLast_4()
		throws Exception {
		int length = 2;
		IncompleteMemory<String> fixture = new IncompleteMemory<String>(length);
		fixture.add("1");
		fixture.add("2");
		fixture.add("3");
		int num = 3;
		
		List<String> expected = new ArrayList<String>();
		expected.add("2");
		expected.add("3");

		List<String> result = fixture.getLast(num);

		assertNotNull(result);
		assertEquals(expected, result);
	}

	@Test
	public void testGetLength_1()
		throws Exception {
		int length = 2;
		IncompleteMemory<String> fixture = new IncompleteMemory<String>(length);
		
		int result = fixture.getLength(); 

		assertEquals(0, result);
	}
	
	@Test
	public void testGetLength_2()
		throws Exception {
		int length = 2;
		IncompleteMemory<String> fixture = new IncompleteMemory<String>(length);
		fixture.add("1");
		
		int result = fixture.getLength(); 

		assertEquals(1, result);
	}
	
	@Test
	public void testGetLength_3()
		throws Exception {
		int length = 2;
		IncompleteMemory<String> fixture = new IncompleteMemory<String>(length);
		fixture.add("1");
		fixture.add("2");
		fixture.add("3");
		
		int result = fixture.getLength(); 

		assertEquals(2, result);
	}

	public static void main(String[] args) {
		new org.junit.runner.JUnitCore().run(IncompleteMemoryTest.class);
	}
}