//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.usability;

import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertNotSame;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import org.junit.Test;

import de.ugoe.cs.autoquest.usability.UsabilityDefectDescription;

/**
 * @author Patrick Harms
 */
public class UsabilityDefectDescriptionTest {

    /**
     * 
     */
    @Test
    public void testInitialization() {
        for (UsabilityDefectDescription description : UsabilityDefectDescription.values()) {
            assertNotNull(description.toString());
            assertNotSame("", description.toString());
            System.err.println(description);
        }
    }

    /**
     * 
     */
    @Test
    public void testParameterization_01() {
        for (UsabilityDefectDescription description : UsabilityDefectDescription.values()) {
            Map<String, Object> parameters = new HashMap<String, Object>();

            for (String parameter : description.getDescriptionParameters()) {
                parameters.put(parameter, "<parameter " + parameter + ">");
            }

            assertNotNull(description.toString(parameters));
            assertNotSame("", description.toString(parameters));
            System.err.println(description.toString(parameters));
        }
    }


    /**
     * 
     */
    @Test
    public void testParameterization_02() {
        for (UsabilityDefectDescription description : UsabilityDefectDescription.values()) {
            Map<String, Object> parameters = new HashMap<String, Object>();

            for (String parameter : description.getDescriptionParameters()) {
                List<String> values = new LinkedList<String>();
                values.add("<parameter " + parameter + " value 1>");
                values.add("<parameter " + parameter + " value 2>");
                values.add("<parameter " + parameter + " value 3>");
                parameters.put(parameter, values);
            }

            assertNotNull(description.toString(parameters));
            assertNotSame("", description.toString(parameters));
            System.err.println(description.toString(parameters));
        }
    }

}
