//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.
package de.ugoe.cs.autoquest.plugin.android.guimodel;

import de.ugoe.cs.autoquest.eventcore.guimodel.IGUIElementSpec;

/**
 * <p>
 * Implements the specification of {@link IGUIElement} for
 * {@link AndroidGUIElement}s.
 * </p>
 * 
 * @version 1.0
 * @author Florian Unger
 */
public class AndroidGUIElementSpec implements IGUIElementSpec {

	// TODO Why is serialVersionUID = 1L initialized by 1L?
	/**
	 * <p>
	 * default serial version UID
	 * </p>
	 */
	private static final long serialVersionUID = 1L;

	/*
	 * (non-Javadoc) see
	 * de.ugoe.cs.autoquest.androidmonitor.AndroidmonitorLogFile logComponent()
	 */
	/**
	 * <p>
	 * Hash code of the GUI element. Used as unique identifier during parsing a
	 * log file. Note that it is possible that the hash code of an element
	 * changes over several log files even if they come from the same target.
	 * </p>
	 */
	private int hashCode;

	/**
	 * <p>
	 * Path to an element in an activity. e.g. a path of a button could look
	 * like MainActivity/DecorView/ActionBarOverlayLayout/FrameLayout/
	 * RelativeLayout/Button
	 * </p>
	 */
	private String path;
	
	/**
	 * <p>
	 * id of the object as it is returned by view.getId()
	 * </p>
	 */
	private int index;

	/**
	 * <p>
	 * the type of GUI element represented by this specification, which is
	 * usually the java class of the android GUI element
	 * </p>
	 */
	private String type;

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.autoquest.eventcore.guimodel.IGUIElementSpec#getType()
	 */
	@Override
	public String getType() {
		return type;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * de.ugoe.cs.autoquest.eventcore.guimodel.IGUIElementSpec#getTypeHierarchy
	 * ()
	 */
	@Override
	public String[] getTypeHierarchy() {
		return new String[] { (getType()) };
		// TODO change this part after adding ancestors in
		// de.ugoe.cs.autoquest.androidmonitor.AndroidmonitorLogFile#addComponent
	}

	@Override
	public boolean getSimilarity(IGUIElementSpec other) {
		if (this == other) {
			return true;
		}

		if (!(other instanceof AndroidGUIElementSpec)) {
			return false;
		}

		// Check wheter view.id() keeps the same even if something in the
		// structure changes. The hash in the JFCMonitor seems to be unique at
		// all. In the Androidmonitore the hash of an element changes even from
		// one start of the activity to another.
		/*
		 * Maybe some other comparisons will be necessary in the future.
		 */

		return false;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode() {
		return hashCode;
	}

	/**
	 * <p>
	 * Returns the path associated with the specified GUI element.
	 * </p>
	 * @return the path to an element
	 */
	public String getPath() {
		return path;
	}

	public int getIndex() {
		return index;
	}

	public void setIndex(int index) {
		this.index = index;
	}

	/**
	 * Set the hash code associated with the GUI element.
	 * @param hash
	 * 				the hash of an element object
	 */
	public void setHashCode(int hash){
		this.hashCode = hash;
	}
	
	/**
	 * Set the path associated with the specified GUI element.
	 * @param path
	 * 				the path to an element
	 */
	public void setPath(String path) {
		this.path = path;
	}
	
	/**
     * <p>
     * Sets the type of the specified GUI element.
     * </p>
     * 
     * @param type
     *            the type
     */
    public void setType(String type) {
        this.type = type;
    }

}
