//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.
package de.ugoe.cs.autoquest.plugin.android.guimodel;

import de.ugoe.cs.autoquest.eventcore.guimodel.IButton;

/**
 * <p>
 * Class that represents buttons in Android GUIs.
 * </p>
 * 
 * @version 1.0
 * @author Florian Unger
 */
public class ANDROIDButton extends ANDROIDGUIElement implements IButton{
	/**
     * <p>
     * Id for object serialization.
     * </p>
     */
    private static final long serialVersionUID = 1L;
    
    /**
     * <p>
     * Constructor. Creates a new AndroidButton.
     * </p>
     * 
     * @param specification
     *            specification of created GUI element
     * @param parent
     *            parent of the created GUI element; null means that the element is a top-level
     *            window
     */
    public ANDROIDButton(ANDROIDGUIElementSpec specification,
			ANDROIDGUIElement parent) {
		super(specification, parent);
		// TODO Auto-generated constructor stub
	}
    
    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.autoquest.plugin.android.guimodel.ANDROIDGUIElement#getElementDescriptor()
     */
    @Override
    protected String getElementDescriptor() {
        return "Button";
    }

}
