//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.usageprofiles;

/**
 * <p>
 * Models implementing this interface provide a graph representation of themselves as a
 * {@link String} with Dot syntax.
 * </p>
 * 
 * @author Steffen Herbold
 * @version 1.0
 */
public interface IDotCompatible {

    /**
     * <p>
     * Returns a Dot representation of the model.
     * </p>
     * 
     * @return string with Dot syntax that describes the model.
     */
    public abstract String getDotRepresentation();
}
