//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.util.console;

import java.util.List;

/**
 * <p>
 * Defines the interface for a command. The class names of the commands must be
 * of the form {@code CMD<commandname>}, otherwise they cannot be used by the
 * {@link CommandExecuter}.
 * </p>
 * 
 * @author Steffen Herbold
 * @version 1.0
 */
public interface Command {

	/**
	 * <p>
	 * Executes a command.
	 * </p>
	 * 
	 * @param parameters
	 *            parameters for the command.
	 */
	public void run(List<Object> parameters);

	/**
	 * <p>
	 * Returns a string the contains information about how to use the command.
	 * </p>
	 * @return help string
	 */
	public String help();
}
