package de.ugoe.cs.autoquest.androidmonitor;

import java.util.ArrayList;
import java.util.List;

import android.view.View;

public class AndroidmonitorCompositeOnClickListener implements
		View.OnClickListener {

	// save all listeners which belongs to a single view in a list
	List<View.OnClickListener> listeners;

	public AndroidmonitorCompositeOnClickListener() {
		listeners = new ArrayList<View.OnClickListener>();
	}

	/**
	 * adds a listener to a single view
	 * 
	 * @param listener
	 */
	public void addOnClickListener(View.OnClickListener listener) {
		listeners.add(listener);
	}

	@Override
	public void onClick(View v) {
		// call all listeners which belongs to a special view
		for (View.OnClickListener listener : listeners) {
			listener.onClick(v);
		}

	}

}

/*
 * In Android it is not possible to have multiple onCliclListener for one view.
 * This is also stated in
 * http://books.google.de/books?id=bKo_1uED72EC&pg=PA178&lpg
 * =PA178&dq=android+setonclicklistener
 * +call+old+listener&source=bl&ots=g45T5ikRVK
 * &sig=blIqJGMywqJEGNATe3WW5DZyS6M&hl
 * =de&sa=X&ei=cl3rU6_8Ec2KOIzqgNgM&ved=0CEYQ6AEwBA
 * #v=onepage&q=android%20setonclicklistener%20call%20old%20listener&f=false
 * 
 * Therefore it is necessary to have a custom class to handle a single onClick()
 * and pass in handlers for it to call.
 * http://stackoverflow.com/questions/7587299
 * /android-multi-onclick-listener-in-one-button
 */