//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.usability.rules;

import com.google.common.base.Optional;

import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskModel;
import de.ugoe.cs.autoquest.usability.EvaluationMethodCaller;
import de.ugoe.cs.autoquest.usability.result.UsabilityProblemDescription;

/**
 * <p>
 * A {@code UsabilityRule} is a abstract class, representing a usability guideline, metric
 * interaction pattern etc., which should be checked during a automatic usability evaluation.
 * </p>
 * 
 * @author Alexander Deicke
 */
public abstract class UsabilityRule {

    /**
     * <p>
     * {@link ITaskModel}, which is evaluated
     * </p>
     */
    protected final ITaskModel taskModel;

    /**
     * <p>
     * Name of the usability rule
     * </p>
     */
    protected String name;

    /**
     * <p>
     * Corresponding defect description.
     * </p>
     */
    protected UsabilityProblemDescription defect;

    /**
     * <p>
     * Constructor. Creates a new {@code UsabilityRule} for a given task model
     * </p>
     * 
     */
    public UsabilityRule(ITaskModel taskModel) {
        this.taskModel = taskModel;
    }

    /**
     * 
     * <p>
     * Calls the evaluation method of this {@code UsabilityRule}.
     * </p>
     * 
     * @param evaluationMethodCaller
     *            helper class, which calls the evaluation method based on the type of the
     *            {@code UsabilityRule}
     * @return {@link UsabilityProblemDescription}, iff violation against usability rule was detected
     */
    public abstract Optional<UsabilityProblemDescription> callEvaluationMethod(EvaluationMethodCaller evaluationMethodCaller);

}
