//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.plugin.usability2.rules.operator.wrapper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import de.ugoe.cs.autoquest.tasktrees.treeifc.IEventTaskInstance;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITask;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskInstance;

/**
 * <p>
 * TODO comment
 * </p>
 * 
 * @author Konni Hartmann
 */
public abstract class AbstractTaskWrapper implements ITaskWrapper {

    /**  */
    private static final long serialVersionUID = 1L;

    Map<ITaskInstance, List<ITaskInstance>> instances =
        new HashMap<ITaskInstance, List<ITaskInstance>>();

    @Override
    public void addFilteredInstance(ITaskInstance filter, ITaskInstance instance) {        
        List<ITaskInstance> list = instances.get(filter);
        if(list == null) {
            list = new ArrayList<ITaskInstance>();
            instances.put(filter, list);
        }
        list.add(instance);
    }

    @Override
    public List<ITaskInstance> getFilteredInstances(ITaskInstance filter) {
        return Collections.unmodifiableList(instances.get(filter));
    }

    public Map<ITaskInstance, List<ITaskInstance>> getFilteredInstances() {
        return Collections.unmodifiableMap(instances);
    }
    
    public Collection<List<IEventTaskInstance>> getInstanceSequences() {
        GenerateInstanceListVisitor visitor = new GenerateInstanceListVisitor();
        return visitor.generateInstanceList(this.getReference());
    }
    
    /* (non-Javadoc)
     * @see de.ugoe.cs.autoquest.plugin.usability2.rules.operator.wrapper.ITaskEntry#getAvailableFilters()
     */
    @Override
    public List<ITaskInstance> getAvailableFilters() {
        return new ArrayList<ITaskInstance>(instances.keySet());
    }
    
    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#clone()
     */
    @Override
    public ITask clone() {
        ITask clone = null;
        try {
            clone = (ITask) super.clone();
        }
        catch (CloneNotSupportedException e) {
            // Ignore
        }
        return clone;
    }
}
