//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.eventcore.gui;

/**
 * <p>
 * Event type for typing strings.
 * </p>
 * 
 * @version 1.0
 * @author Florian Unger
 */
public class CharacterTyped implements IInteraction {

    /**
     * <p>
     * Id for object serialization.
     * </p>
     */
    private static final long serialVersionUID = 1L;

    /**
     * <p>
     * The string associated with the interaction.
     * </p>
     */
    private String string;

    /**
     * <p>
     * Constructor. Creates a new CharacterTyped.
     * </p>
     * 
     * @param string
     *            string associated with the interaction
     */
    public CharacterTyped(String string) {
        this.string = string;
    }

    @Override
    public String getName() {
        return "StringTyped: " + string;
    }

    @Override
    public boolean startsLogicalSequence() {
        return false;
    }

    @Override
    public boolean finishesLogicalSequence() {
        return false;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#equals(java.lang.Object)
     */
    @Override
    public boolean equals(Object obj) {
        if (obj instanceof CharacterTyped) {
            return (((CharacterTyped) obj).getString() == getString());
        }
        return false;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#hashCode()
     */
    @Override
    public int hashCode() {
        return getString().hashCode();
    }

    /**
     * <p>
     * Returns the string associated with the interaction.
     * </p>
     * 
     * @return the string
     */
    public String getString() {
        return string;
    }

}
