//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.plugin.usability2.rules.operator.wrapper;

import java.util.List;

import de.ugoe.cs.autoquest.tasktrees.treeifc.IEventTaskInstance;
import de.ugoe.cs.autoquest.tasktrees.treeifc.IIterationInstance;
import de.ugoe.cs.autoquest.tasktrees.treeifc.IOptionalInstance;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ISelectionInstance;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ISequenceInstance;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITask;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskInstance;


public abstract class AbstractTaskEntryInstanceVisitor implements ITaskEntryVisitor {

    public abstract void visitInstanceEntry(IEventTaskInstance value);
    
    private void visitSequence(ISequenceInstance value) {
        List<ITaskInstance> children = value.getChildren();
        for (ITaskInstance child : children) {
            visitInstance(child);
        }        
    }

    private void visitIteration(IIterationInstance value) {
        List<ITaskInstance> children = value.getChildren();
        for (ITaskInstance child : children) {
            visitInstance(child);
        }
    }

    private void visitSelection(ISelectionInstance value) {
        ITaskInstance child = value.getChild();
        if(child != null)
            visitInstance(child);        
    }

    private void visitOptional(IOptionalInstance value) {
        ITaskInstance child = value.getChild();
        if(child != null)
            visitInstance(child);
    }
    
    protected void visitInstance(ITaskInstance value) {
        if (value instanceof IEventTaskInstance) {
            visitInstanceEntry((IEventTaskInstance) value);
        } else if (value instanceof ISequenceInstance) {
            visitSequence((ISequenceInstance) value);
        } else if (value instanceof IIterationInstance) {
            visitIteration((IIterationInstance) value);
        } else if (value instanceof ISelectionInstance) {
            visitSelection((ISelectionInstance) value);
        } else if (value instanceof IOptionalInstance) {
            visitOptional((IOptionalInstance) value);
        }
        
    }

    public void visit(ITask value) {        
        for (ITaskInstance instance : value.getInstances()) {
            visitInstance(instance);
        }
    }
    
    @Override
    public void visit(ITaskEntry value) {
        visit(value.getReference());
    }

}
