//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.tasktrees.taskequality;

import de.ugoe.cs.autoquest.tasktrees.treeifc.ITask;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskInstance;

// TODO: Auto-generated Javadoc
/**
 * <p>
 * This comparison rule returns <code>TaskEquality.IDENTICAL</code> if the
 * comparison of the two tasks using the <code>==</code> operator returns true.
 * Else it returns null to denote, that it can not compare the tasks.
 * </p>
 *
 * @author 2012, last modified by $Author: patrick$
 * @version $Revision: $ $Date: 19.02.2012$
 */
public class TaskIdentityRule implements TaskComparisonRule {

	/*
	 * (non-Javadoc)
	 * 
	 * @see TaskComparisonRule#areLexicallyEqual(ITask, ITask)
	 */
	@Override
	public boolean areLexicallyEqual(ITask task1, ITask task2) {
		return (task1 == task2);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see TaskComparisonRule#areLexicallyEqual(ITaskInstance, ITaskInstance)
	 */
	@Override
	public boolean areLexicallyEqual(ITaskInstance instance1,
			ITaskInstance instance2) {
		return (instance1.getTask() == instance2.getTask());
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see TaskComparisonRule#areSemanticallyEqual(ITask, ITask)
	 */
	@Override
	public boolean areSemanticallyEqual(ITask task1, ITask task2) {
		return (task1 == task2);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see TaskComparisonRule#areSemanticallyEqual(ITaskInstance,
	 * ITaskInstance)
	 */
	@Override
	public boolean areSemanticallyEqual(ITaskInstance instance1,
			ITaskInstance instance2) {
		return (instance1.getTask() == instance2.getTask());
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see TaskComparisonRule#areSyntacticallyEqual(ITask, ITask)
	 */
	@Override
	public boolean areSyntacticallyEqual(ITask task1, ITask task2) {
		return (task1 == task2);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see TaskComparisonRule#areSyntacticallyEqual(ITaskInstance,
	 * ITaskInstance)
	 */
	@Override
	public boolean areSyntacticallyEqual(ITaskInstance instance1,
			ITaskInstance instance2) {
		return (instance1.getTask() == instance2.getTask());
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see TaskComparisonRule#compare(ITask, ITask)
	 */
	@Override
	public TaskEquality compare(ITask task1, ITask task2) {
		if (isApplicable(task1, task2)) {
			return TaskEquality.IDENTICAL;
		} else {
			return null;
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see TaskComparisonRule#compare(ITaskInstance, ITaskInstance)
	 */
	@Override
	public TaskEquality compare(ITaskInstance instance1, ITaskInstance instance2) {
		if (isApplicable(instance1, instance2)) {
			return TaskEquality.IDENTICAL;
		} else {
			return null;
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see TaskComparisonRule#isApplicable(ITask, ITask)
	 */
	@Override
	public boolean isApplicable(ITask task1, ITask task2) {
		return (task1 == task2);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see TaskComparisonRule#isApplicable(ITaskInstance, ITaskInstance)
	 */
	@Override
	public boolean isApplicable(ITaskInstance instance1, ITaskInstance instance2) {
		return (instance1.getTask() == instance2.getTask());
	}

}
