
package de.ugoe.cs.autoquest.plugin.usability2.rules;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import de.ugoe.cs.autoquest.usability.rules.UsabilityRule;
import de.ugoe.cs.autoquest.usability.rules.UsabilityRuleset;

public class CombinedRuleset implements UsabilityRuleset {

    ArrayList<UsabilityRule> rules;

    public CombinedRuleset(UsabilityRuleset... rulesets) {
        this.rules = new ArrayList<UsabilityRule>();
        for (UsabilityRuleset ruleset : rulesets) {
            this.rules.addAll(ruleset.evaluationRules());
        }
    }

    @Override
    public List<UsabilityRule> evaluationRules() {
        return Collections.unmodifiableList(rules);
    }

    public CombinedRuleset add(UsabilityRuleset ruleset) {
        this.rules.addAll(ruleset.evaluationRules());
        return this;
    }
    
    public CombinedRuleset add(UsabilityRule rule) {
        this.rules.add(rule);
        return this;
    }
}
