package de.ugoe.cs.eventbench.swt;

import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.FillLayout;

public class ModelProperties extends Dialog {

	protected Object result;
	protected Shell shlModelProperties;

	/**
	 * Create the dialog.
	 * @param parent
	 * @param style
	 */
	public ModelProperties(Shell parent, int style) {
		super(parent, style);
		setText("SWT Dialog");
	}

	/**
	 * Open the dialog.
	 * @return the result
	 */
	public Object open() {
		createContents();
		shlModelProperties.open();
		shlModelProperties.layout();
		Display display = getParent().getDisplay();
		while (!shlModelProperties.isDisposed()) {
			if (!display.readAndDispatch()) {
				display.sleep();
			}
		}
		return result;
	}

	/**
	 * Create contents of the dialog.
	 */
	private void createContents() {
		shlModelProperties = new Shell(getParent(), SWT.DIALOG_TRIM | SWT.RESIZE);
		shlModelProperties.setSize(230, 318);
		shlModelProperties.setText("Model Properties");
		shlModelProperties.setLayout(new GridLayout(2, false));
		
		Group grpEvents = new Group(shlModelProperties, SWT.NONE);
		FillLayout fl_grpEvents = new FillLayout(SWT.HORIZONTAL);
		fl_grpEvents.marginHeight = 5;
		fl_grpEvents.marginWidth = 5;
		grpEvents.setLayout(fl_grpEvents);
		grpEvents.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 2, 1));
		grpEvents.setText("Events");
		
		List list = new List(grpEvents, SWT.BORDER | SWT.V_SCROLL);
		
		Group grpStatistics = new Group(shlModelProperties, SWT.NONE);
		grpStatistics.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false, 2, 1));
		grpStatistics.setText("Statistics");
		grpStatistics.setLayout(new GridLayout(2, false));
		
		Label lblNumEvents = new Label(grpStatistics, SWT.NONE);
		lblNumEvents.setLayoutData(new GridData(SWT.FILL, SWT.TOP, true, false, 1, 1));
		lblNumEvents.setText("Num. Events");
		
		Label label = new Label(grpStatistics, SWT.RIGHT);
		label.setLayoutData(new GridData(SWT.RIGHT, SWT.TOP, false, false, 1, 1));
		label.setText("####");
		
		Label lblNumTrieLeafs = new Label(grpStatistics, SWT.NONE);
		lblNumTrieLeafs.setLayoutData(new GridData(SWT.FILL, SWT.TOP, true, false, 1, 1));
		lblNumTrieLeafs.setText("Size (#Trie Leafs)");
		
		Label label_1 = new Label(grpStatistics, SWT.RIGHT);
		label_1.setLayoutData(new GridData(SWT.RIGHT, SWT.TOP, false, false, 1, 1));
		label_1.setText("####");
		
		Label lblEntropy = new Label(grpStatistics, SWT.NONE);
		lblEntropy.setLayoutData(new GridData(SWT.FILL, SWT.TOP, true, false, 1, 1));
		lblEntropy.setText("Entropy");
		
		Label label_2 = new Label(grpStatistics, SWT.RIGHT);
		label_2.setLayoutData(new GridData(SWT.RIGHT, SWT.TOP, false, false, 1, 1));
		label_2.setText("####");
		
		Button btnCalculateEntropy = new Button(shlModelProperties, SWT.NONE);
		btnCalculateEntropy.setText("Calculate Entropy");
		
		Button btnClose = new Button(shlModelProperties, SWT.NONE);
		btnClose.setText("Close");

	}
}
