//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.eventcore.gui;

/**
 * <p>
 * Event type for keyboard focus changes. The target of the respective event has obtained the
 * keyboard focus of the application.
 * </p>
 * 
 * @version 1.0
 * @author Patrick Harms
 */
public class KeyboardFocusChange implements IInteraction {

    /**
     * <p>
     * Id for object serialization.
     * </p>
     */
    private static final long serialVersionUID = 1L;

    /*
     * (non-Javadoc)
     * 
     * @see de.harms.attef.userinteraction.Interaction#getName()
     */
    public String getName() {
        return "KeyboardFocusChange";
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.tasktree.userinteraction.Interaction#startsLogicalSequence()
     */
    @Override
    public boolean startsLogicalSequence() {
        return true;
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.tasktree.userinteraction.Interaction#finishesLogicalSequence()
     */
    @Override
    public boolean finishesLogicalSequence() {
        return true;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        return "KB focus changed";
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#equals(java.lang.Object)
     */
    @Override
    public boolean equals(Object obj) {
        if (obj instanceof KeyboardFocusChange) {
            return true;
        }
        return false;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#hashCode()
     */
    @Override
    public int hashCode() {
        return getClass().hashCode();
    }
}
